/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.structure.container.ContainerTownSelection;
import net.shadowmage.ancientwarfare.structure.town.TownTemplate;
import net.shadowmage.ancientwarfare.structure.town.TownTemplateManager;

public class GuiTownSelection
extends GuiContainerBase<ContainerTownSelection> {
    private TownTemplate currentSelection;
    private CompositeScrolled selectionArea;
    private Label selection;

    public GuiTownSelection(ContainerBase container) {
        super(container, 257, 240);
    }

    protected GuiTownSelection(ContainerBase container, int xSize, int ySize) {
        super(container, xSize, ySize);
    }

    @Override
    public void initElements() {
        this.addGuiElement(new Button(this.field_146999_f - 55 - 8, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                if (GuiTownSelection.this.currentSelection != null) {
                    ((ContainerTownSelection)((Object)GuiTownSelection.this.getContainer())).handleNameSelection(GuiTownSelection.this.currentSelection.getTownTypeName());
                    ((ContainerTownSelection)((Object)GuiTownSelection.this.getContainer())).addSlots();
                    GuiTownSelection.this.closeGui();
                }
            }
        });
        Label label = new Label(8, 8, "guistrings.current_selection");
        this.addGuiElement(label);
        this.selection = new Label(8, 20, "");
        this.addGuiElement(this.selection);
        this.addGuiElement(new Label(8, 34, "Width"));
        NumberInput chunkWidth = new NumberInput(40, 33, 10, ((ContainerTownSelection)((Object)this.getContainer())).getWidth(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerTownSelection)((Object)GuiTownSelection.this.getContainer())).handleWidthUpdate((int)value);
            }
        };
        chunkWidth.setIntegerValue();
        this.addGuiElement(chunkWidth);
        this.addGuiElement(new Label(56, 34, "Length"));
        NumberInput chunkLength = new NumberInput(94, 33, 10, ((ContainerTownSelection)((Object)this.getContainer())).getLength(), this){

            @Override
            public void onValueUpdated(float value) {
                ((ContainerTownSelection)((Object)GuiTownSelection.this.getContainer())).handleLengthUpdate((int)value);
            }
        };
        chunkLength.setIntegerValue();
        this.addGuiElement(chunkLength);
        this.selectionArea = new CompositeScrolled(this, 0, 50, 256, 190);
        this.addGuiElement(this.selectionArea);
        TownTemplateManager.INSTANCE.getTemplate(((ContainerTownSelection)((Object)this.getContainer())).townName).ifPresent(this::setSelection);
    }

    @Override
    public void setupElements() {
        this.selectionArea.clearElements();
        this.selection.setText(this.currentSelection == null ? "guistrings.none" : this.currentSelection.getTownTypeName());
        int totalHeight = 8;
        for (TownTemplate template : this.getTownTemplatesSorted()) {
            TemplateButton button = new TemplateButton(8, totalHeight, template);
            this.selectionArea.addGuiElement(button);
            totalHeight += 12;
        }
        this.selectionArea.setAreaSize(totalHeight + 8);
    }

    private List<TownTemplate> getTownTemplatesSorted() {
        return TownTemplateManager.INSTANCE.getTemplates().stream().sorted(Comparator.comparing(t -> t.getTownTypeName().toLowerCase())).collect(Collectors.toList());
    }

    private void setSelection(TownTemplate template) {
        this.currentSelection = template;
        this.selection.setText(template == null ? "guistrings.none" : template.getTownTypeName());
    }

    private class TemplateButton
    extends Button {
        TownTemplate template;

        public TemplateButton(int topLeftX, int topLeftY, TownTemplate template) {
            super(topLeftX, topLeftY, 232, 12, template.getTownTypeName());
            this.template = template;
        }

        @Override
        protected void onPressed() {
            GuiTownSelection.this.setSelection(this.template);
        }
    }
}

