/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Line;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.util.SongPlayData;
import net.shadowmage.ancientwarfare.structure.container.ContainerSoundBlock;
import net.shadowmage.ancientwarfare.structure.gui.GuiSoundSelect;
import net.shadowmage.ancientwarfare.structure.util.BlockSongPlayData;

public class GuiSoundBlock
extends GuiContainerBase<ContainerSoundBlock> {
    private CompositeScrolled area;
    private Checkbox playerEntry;
    private Checkbox loop;
    private Checkbox anyTime;
    private Checkbox day;
    private Checkbox night;

    public GuiSoundBlock(ContainerBase container) {
        super(container, 320, 240);
    }

    @Override
    public void initElements() {
    }

    @Override
    public void setupElements() {
        this.clearElements();
        int totalHeight = 8;
        final BlockSongPlayData data = ((ContainerSoundBlock)((Object)this.getContainer())).data;
        this.playerEntry = new Checkbox(8, totalHeight, 12, 12, "guistrings.play_on_player_entry"){

            @Override
            public void onToggled() {
                data.setPlayOnPlayerEntry(this.checked());
                GuiSoundBlock.this.loop.setChecked(!this.checked());
                GuiSoundBlock.this.refreshGui();
            }
        };
        this.playerEntry.setChecked(data.getPlayOnPlayerEntry());
        this.addGuiElement(this.playerEntry);
        totalHeight += 16;
        if (this.playerEntry.checked()) {
            totalHeight = this.addPlayerEntryElements(totalHeight);
        }
        this.loop = new Checkbox(8, totalHeight, 12, 12, "guistrings.sound_block.loop"){

            @Override
            public void onToggled() {
                data.setPlayOnPlayerEntry(!this.checked());
                GuiSoundBlock.this.playerEntry.setChecked(!this.checked());
                GuiSoundBlock.this.refreshGui();
            }
        };
        this.loop.setChecked(!data.getPlayOnPlayerEntry());
        this.addGuiElement(this.loop);
        totalHeight += 16;
        if (this.loop.checked()) {
            totalHeight = this.addLoopElements(totalHeight);
        }
        this.anyTime = new Checkbox(10, totalHeight += 4, 12, 12, "guistrings.sound_block.any_time"){

            @Override
            public void onToggled() {
                if (this.checked()) {
                    data.setTimeOfDay(BlockSongPlayData.TimeOfDay.ANY);
                    GuiSoundBlock.this.day.setChecked(false);
                    GuiSoundBlock.this.night.setChecked(false);
                }
            }
        };
        this.anyTime.setChecked(data.getTimeOfDay() == BlockSongPlayData.TimeOfDay.ANY);
        this.addGuiElement(this.anyTime);
        this.day = new Checkbox(74, totalHeight, 12, 12, "guistrings.sound_block.day"){

            @Override
            public void onToggled() {
                if (this.checked()) {
                    data.setTimeOfDay(BlockSongPlayData.TimeOfDay.DAY);
                    GuiSoundBlock.this.anyTime.setChecked(false);
                    GuiSoundBlock.this.night.setChecked(false);
                }
            }
        };
        this.day.setChecked(data.getTimeOfDay() == BlockSongPlayData.TimeOfDay.DAY);
        this.addGuiElement(this.day);
        this.night = new Checkbox(122, totalHeight, 12, 12, "guistrings.sound_block.night"){

            @Override
            public void onToggled() {
                if (this.checked()) {
                    data.setTimeOfDay(BlockSongPlayData.TimeOfDay.NIGHT);
                    GuiSoundBlock.this.anyTime.setChecked(false);
                    GuiSoundBlock.this.day.setChecked(false);
                }
            }
        };
        this.night.setChecked(data.getTimeOfDay() == BlockSongPlayData.TimeOfDay.NIGHT);
        this.addGuiElement(this.night);
        Checkbox protectionFlagTurnOff = new Checkbox(8, totalHeight += 14, 16, 16, "guistrings.sound_block.turned_off_by_protection_flag"){

            @Override
            public void onToggled() {
                data.setProtectionFlagTurnOff(this.checked());
            }
        };
        protectionFlagTurnOff.setChecked(data.getProtectionFlagTurnOff());
        this.addGuiElement(protectionFlagTurnOff);
        Checkbox random = new Checkbox(8, totalHeight += 18, 16, 16, "guistrings.sound_block.play_in_random_order"){

            @Override
            public void onToggled() {
                data.setRandom(this.checked());
            }
        };
        random.setChecked(data.getIsRandom());
        this.addGuiElement(random);
        this.addGuiElement(new Label(32, (totalHeight += 20) + 1, "guistrings.sound_block.sound_range").setShadow(true));
        NumberInput soundRange = new NumberInput(8, totalHeight, 22, data.getSoundRange(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setSoundRange((int)value);
            }
        };
        soundRange.setIntegerValue();
        this.addGuiElement(soundRange);
        int areaHeight = this.addTuneEntries(data, totalHeight += 14);
        Button newTuneButton = new Button(8, areaHeight, 120, 12, "guistrings.new_tune"){

            @Override
            protected void onPressed() {
                data.addNewEntry();
                GuiSoundBlock.this.refreshGui();
            }
        };
        this.area.addGuiElement(newTuneButton);
        this.area.setAreaSize(areaHeight += 16);
    }

    private int addLoopElements(int totalHeight) {
        final BlockSongPlayData data = ((ContainerSoundBlock)((Object)this.getContainer())).data;
        NumberInput minDelay = new NumberInput(74, totalHeight += 2, 28, data.getMinDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setMinDelay((int)value);
            }
        };
        minDelay.setIntegerValue();
        this.addGuiElement(minDelay);
        this.addGuiElement(new Label(24, totalHeight + 1, "guistrings.min_delay").setShadow(true));
        NumberInput maxDelay = new NumberInput(170, totalHeight, 28, data.getMaxDelay(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setMaxDelay((int)value);
            }
        };
        maxDelay.setIntegerValue();
        this.addGuiElement(maxDelay);
        this.addGuiElement(new Label(116, totalHeight + 1, "guistrings.max_delay").setShadow(true));
        final NumberInput repetitions = new NumberInput(100, (totalHeight += 14) + 2, 22, data.getRepetitions(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setRepetitions((int)value);
            }
        };
        repetitions.setIntegerValue();
        repetitions.setEnabled(data.getLimitedRepetitions());
        this.addGuiElement(repetitions);
        Checkbox limitedRepetitions = new Checkbox(24, totalHeight, 16, 16, "guistrings.sound_block.stop_after"){

            @Override
            public void onToggled() {
                data.setLimitedRepetitions(this.checked());
                repetitions.setEnabled(this.checked());
            }
        };
        limitedRepetitions.setChecked(data.getLimitedRepetitions());
        this.addGuiElement(limitedRepetitions);
        this.addGuiElement(new Label(128, totalHeight + 4, "guistrings.sound_block.repetitions").setShadow(true));
        final NumberInput limitRange = new NumberInput(184, (totalHeight += 18) + 2, 22, data.getPlayerRange(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setPlayerRange((int)value);
            }
        };
        limitRange.setIntegerValue();
        limitRange.setEnabled(data.getWhenInRange());
        this.addGuiElement(limitRange);
        Checkbox whenInRange = new Checkbox(24, totalHeight, 16, 16, "guistrings.sound_block.play_when_player_less_than"){

            @Override
            public void onToggled() {
                data.setWhenInRange(this.checked());
                limitRange.setEnabled(this.checked());
            }
        };
        whenInRange.setChecked(data.getWhenInRange());
        this.addGuiElement(whenInRange);
        this.addGuiElement(new Label(210, totalHeight + 4, "guistrings.sound_block.blocks_away").setShadow(true));
        return totalHeight += 18;
    }

    private int addPlayerEntryElements(int totalHeight) {
        final BlockSongPlayData data = ((ContainerSoundBlock)((Object)this.getContainer())).data;
        this.addGuiElement(new Label(24, (totalHeight += 2) + 1, "guistrings.sound_block.range").setShadow(true));
        NumberInput playerEntryRange = new NumberInput(60, totalHeight, 22, data.getPlayerRange(), this){

            @Override
            public void onValueUpdated(float value) {
                data.setPlayerRange((int)value);
            }
        };
        playerEntryRange.setIntegerValue();
        this.addGuiElement(playerEntryRange);
        Checkbox onlyOnce = new Checkbox(100, totalHeight - 2, 16, 16, "guistrings.sound_block.only_once"){

            @Override
            public void onToggled() {
                data.setPlayOnce(this.checked());
            }
        };
        onlyOnce.setChecked(data.getPlayOnce());
        this.addGuiElement(onlyOnce);
        totalHeight += 16;
        return totalHeight += 2;
    }

    private int addTuneEntries(BlockSongPlayData data, int areaStartY) {
        this.area = new CompositeScrolled(this, 0, areaStartY, this.field_146999_f, this.field_147000_g - areaStartY);
        this.addGuiElement(this.area);
        int areaHeight = 4;
        for (int i = 0; i < data.size(); ++i) {
            areaHeight = this.addTuneEntry(data.get(i), i, areaHeight);
        }
        return areaHeight;
    }

    private int addTuneEntry(final SongPlayData.SongEntry entry, final int index, int startHeight) {
        Button input = new Button(8, startHeight, 294, 12, this.getShortenedName(entry.name())){

            @Override
            public void onPressed() {
                Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiSoundSelect(GuiSoundBlock.this, entry));
                GuiSoundBlock.this.refreshGui();
            }
        };
        this.area.addGuiElement(input);
        this.area.addGuiElement(new Label(8, (startHeight += 14) + 1, "guistrings.volume").setShadow(true));
        NumberInput volume = new NumberInput(50, startHeight, 22, entry.volume(), this){

            @Override
            public void onValueUpdated(float value) {
                entry.setVolume((int)value);
            }
        };
        volume.setIntegerValue();
        this.area.addGuiElement(volume);
        this.area.addGuiElement(new Button(135, startHeight, 20, 12, "/\\"){

            @Override
            protected void onPressed() {
                BlockSongPlayData data = ((ContainerSoundBlock)((Object)GuiSoundBlock.this.getContainer())).data;
                data.decrementEntry(index);
                GuiSoundBlock.this.refreshGui();
            }
        });
        this.area.addGuiElement(new Button(155, startHeight, 20, 12, "\\/"){

            @Override
            protected void onPressed() {
                BlockSongPlayData data = ((ContainerSoundBlock)((Object)GuiSoundBlock.this.getContainer())).data;
                data.incrementEntry(index);
                GuiSoundBlock.this.refreshGui();
            }
        });
        this.area.addGuiElement(new Button(247, startHeight, 55, 12, "guistrings.delete"){

            @Override
            protected void onPressed() {
                BlockSongPlayData data = ((ContainerSoundBlock)((Object)GuiSoundBlock.this.getContainer())).data;
                data.deleteEntry(index);
                GuiSoundBlock.this.refreshGui();
            }
        });
        this.area.addGuiElement(new Line(0, (startHeight += 16) + 2, this.field_146999_f, startHeight + 2, 1, 255));
        return startHeight += 5;
    }

    private String getShortenedName(String name) {
        return name.replace("ancientwarfarestructure:auto_load/", "auto:");
    }

    @Override
    protected boolean onGuiCloseRequested() {
        ((ContainerSoundBlock)((Object)this.getContainer())).sendTuneDataToServer(this.player);
        return true;
    }
}

