/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.nbt.NBTException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiSelectFromList;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.Composite;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemToggleButton;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.structure.container.ContainerLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.item.ItemLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class GuiLootChestPlacer
extends GuiContainerBase<ContainerLootChestPlacer> {
    private static final int FORM_WIDTH = 300;
    private static final int FORM_HEIGHT = 240;
    private static final String LOOT_TABLE_PREFIX = "ancientwarfare:chests/";
    private static final String COMPAT_LOOT_TABLE_PREFIX = "ancientwarfare:chests/compat/";
    private Checkbox setLootTable;
    private Checkbox splashPotion;
    private Checkbox playerMessage;

    public GuiLootChestPlacer(ContainerBase container) {
        super(container, 300, 240);
    }

    @Override
    public void initElements() {
    }

    private void setLootSettings(Consumer<LootSettings> setLootSetting) {
        LootSettings lootSettings = ((ContainerLootChestPlacer)((Object)this.getContainer())).getLootSettings().orElse(new LootSettings());
        setLootSetting.accept(lootSettings);
        ((ContainerLootChestPlacer)((Object)this.getContainer())).setLootSettings(lootSettings);
    }

    private <T> Optional<T> getLootSetting(Function<LootSettings, T> getSetting) {
        return ((ContainerLootChestPlacer)((Object)this.getContainer())).getLootSettings().map(getSetting);
    }

    private int addSpawnEntityElements(int totalHeight) {
        int x = 28;
        this.addGuiElement(new Button(x, totalHeight, 250, 12, this.getLootSetting(LootSettings::getEntity).map(ResourceLocation::toString).orElse("")){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(GuiLootChestPlacer.this, this.text, s -> s, this::getEntityNames, s -> {
                    this.setText((String)s);
                    GuiLootChestPlacer.this.setLootSettings(settings -> settings.setEntity(new ResourceLocation(s)));
                }));
                GuiLootChestPlacer.this.refreshGui();
            }

            private List<String> getEntityNames() {
                return ForgeRegistries.ENTITIES.getKeys().stream().map(ResourceLocation::toString).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
            }
        });
        this.addGuiElement(new Label(x, (totalHeight += 16) + 2, "guistring.loot_placer.entity_nbt"));
        this.addGuiElement(new Text(x + 60, totalHeight, 190, this.getLootSetting(s -> s.getEntityNBT().toString()).orElse(""), this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                try {
                    NBTTagCompound entityNBT = JsonToNBT.func_180713_a((String)newText);
                    GuiLootChestPlacer.this.setLootSettings(s -> s.setEntityNBT(entityNBT));
                }
                catch (NBTException nBTException) {
                    // empty catch block
                }
            }
        });
        return totalHeight + 16;
    }

    private String shortenCompatLootTables(String s) {
        if (s.startsWith(COMPAT_LOOT_TABLE_PREFIX)) {
            return LOOT_TABLE_PREFIX + s.substring(s.indexOf(47, COMPAT_LOOT_TABLE_PREFIX.length()) + 1);
        }
        return s;
    }

    private int addSetLootTableElements(int totalHeight) {
        int x = 28;
        Button selection = new Button(x, totalHeight, 250, 12, this.getLootSetting(s -> s.getLootTableName().map(lootTable -> this.shortenCompatLootTables(lootTable.toString())).orElse("")).orElse("")){

            @Override
            protected void onPressed() {
                Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(GuiLootChestPlacer.this, GuiLootChestPlacer.this.getLootSetting(settings -> settings.getLootTableName().map(ResourceLocation::toString).orElse("")).orElse(""), x$0 -> GuiLootChestPlacer.this.shortenCompatLootTables(x$0), () -> ((ContainerLootChestPlacer)((Object)((Object)GuiLootChestPlacer.this.getContainer()))).getLootTableNames().stream().sorted(Comparator.naturalOrder()).collect(Collectors.toList()), s -> {
                    this.setText(GuiLootChestPlacer.this.shortenCompatLootTables(s));
                    GuiLootChestPlacer.this.setLootSettings(settings -> settings.setLootTableName(new ResourceLocation(s)));
                }));
                GuiLootChestPlacer.this.refreshGui();
            }
        };
        this.addGuiElement(selection);
        this.addGuiElement(new Label(x, totalHeight += 18, "guistrings.loot_rolls"));
        NumberInput lootRolls = new NumberInput(100, totalHeight - 2, 15, this.getLootSetting(LootSettings::getLootRolls).orElse(1).intValue(), this){

            @Override
            public void onValueUpdated(float value) {
                GuiLootChestPlacer.this.setLootSettings(settings -> settings.setLootRolls((int)value));
            }
        };
        lootRolls.setIntegerValue();
        this.addGuiElement(lootRolls);
        return totalHeight + 16;
    }

    private int addSplashPotionElements(int totalHeight) {
        int x = 28;
        this.addGuiElement(new Label(x, totalHeight, "guistrings.loot_placer.potion"));
        this.addGuiElement(new Label(x + 130, totalHeight, "guistrings.loot_placer.duration"));
        this.addGuiElement(new Label(x + 200, totalHeight, "guistrings.loot_placer.strength"));
        totalHeight += 16;
        Optional<List> potionEffects = this.getLootSetting(LootSettings::getEffects);
        if (potionEffects.isPresent()) {
            final List effects = potionEffects.get();
            for (int i = 0; i < effects.size(); ++i) {
                final int effectIndex = i;
                this.addGuiElement(new PotionEffectElement(x, totalHeight, (PotionEffect)effects.get(i), this, effect -> {
                    effects.set(effectIndex, effect);
                    this.setLootSettings(s -> s.setEffects(effects));
                }));
                this.addGuiElement(new Button(x + 230, totalHeight, 20, 12, "-"){

                    @Override
                    protected void onPressed() {
                        effects.remove(effectIndex);
                        GuiLootChestPlacer.this.refreshGui();
                        GuiLootChestPlacer.this.setLootSettings(s -> s.setEffects(effects));
                    }
                });
                totalHeight += 16;
                this.setLootSettings(s -> s.setEffects(effects));
            }
            this.addGuiElement(new Button(x, totalHeight, 20, 12, "+"){

                @Override
                protected void onPressed() {
                    effects.add(new PotionEffect(MobEffects.field_76436_u, 200, 1));
                    GuiLootChestPlacer.this.refreshGui();
                    GuiLootChestPlacer.this.setLootSettings(s -> s.setEffects(effects));
                }
            });
            totalHeight += 16;
        }
        return totalHeight;
    }

    private int addPlayerMessageElements(int totalHeight) {
        int x = 28;
        this.addGuiElement(new Label(x, totalHeight + 2, "guistrings.loot_placer.message"));
        this.addGuiElement(new Text(x + 60, totalHeight, 190, this.getLootSetting(LootSettings::getPlayerMessage).orElse(""), this){

            @Override
            public void onTextUpdated(String oldText, String newText) {
                GuiLootChestPlacer.this.setLootSettings(s -> s.setPlayerMessage(newText));
            }
        });
        return totalHeight;
    }

    private int addPlaceBlockElements(int totalHeight) {
        int x = 8;
        final LinkedHashSet<8> stackToggles = new LinkedHashSet<8>();
        ItemLootChestPlacer.LootContainerInfo selectedContainer = ((ContainerLootChestPlacer)((Object)this.getContainer())).getLootContainerInfo();
        for (final ItemLootChestPlacer.LootContainerInfo container : ItemLootChestPlacer.getLootContainers().values()) {
            ItemStack containerStack = container.getStack();
            ItemToggleButton button = new ItemToggleButton(x, totalHeight, containerStack.func_77946_l(), false){

                @Override
                protected void onPressed(int mButton) {
                    if (this.isToggled()) {
                        ((ContainerLootChestPlacer)((Object)GuiLootChestPlacer.this.getContainer())).setContainer(container.getName());
                        for (ItemToggleButton btn : stackToggles) {
                            if (btn == this) continue;
                            btn.setToggled(false);
                        }
                    }
                }
            };
            button.addTooltip(containerStack.func_82833_r());
            button.setToggled(container.getName().equals(selectedContainer.getName()));
            stackToggles.add(button);
            this.addGuiElement(button);
            if ((x += 24) < 296) continue;
            x = 8;
            totalHeight = 40;
        }
        return totalHeight + 30;
    }

    @Override
    public void setupElements() {
        this.clearElements();
        int totalHeight = 8;
        this.addGuiElement(new Label(8, totalHeight, "guistrings.loot_placer.place_block"));
        totalHeight += 10;
        totalHeight = this.addPlaceBlockElements(totalHeight);
        this.setLootTable = new Checkbox(8, totalHeight, 16, 16, "guistrings.loot_placer.set_loot_table"){

            @Override
            public void onToggled() {
                GuiLootChestPlacer.this.setLootSettings(settings -> settings.setHasLoot(GuiLootChestPlacer.this.setLootTable.checked()));
                GuiLootChestPlacer.this.refreshGui();
            }
        };
        this.setLootTable.setChecked(this.getLootSetting(LootSettings::getHasLoot).orElse(false));
        this.addGuiElement(this.setLootTable);
        totalHeight += 20;
        if (this.setLootTable.checked()) {
            totalHeight = this.addSetLootTableElements(totalHeight);
        }
        this.splashPotion = new Checkbox(8, totalHeight, 16, 16, "guistrings.loot_placer.splash_potion"){

            @Override
            public void onToggled() {
                GuiLootChestPlacer.this.setLootSettings(settings -> settings.setSplashPotion(GuiLootChestPlacer.this.splashPotion.checked()));
                GuiLootChestPlacer.this.refreshGui();
            }
        };
        this.splashPotion.setChecked(this.getLootSetting(LootSettings::getSplashPotion).orElse(false));
        this.addGuiElement(this.splashPotion);
        totalHeight += 20;
        if (this.splashPotion.checked()) {
            totalHeight = this.addSplashPotionElements(totalHeight);
        }
        Checkbox spawnEntity = new Checkbox(8, totalHeight, 16, 16, "guistrings.loot_placer.spawn_entity"){

            @Override
            public void onToggled() {
                GuiLootChestPlacer.this.setLootSettings(settings -> settings.setSpawnEntity(this.checked()));
                GuiLootChestPlacer.this.refreshGui();
            }
        };
        spawnEntity.setChecked(this.getLootSetting(LootSettings::getSpawnEntity).orElse(false));
        this.addGuiElement(spawnEntity);
        totalHeight += 20;
        if (spawnEntity.checked()) {
            totalHeight = this.addSpawnEntityElements(totalHeight);
        }
        this.playerMessage = new Checkbox(8, totalHeight, 16, 16, "guistrings.loot_placer.player_message"){

            @Override
            public void onToggled() {
                GuiLootChestPlacer.this.setLootSettings(settings -> settings.setHasMessage(GuiLootChestPlacer.this.playerMessage.checked()));
                GuiLootChestPlacer.this.refreshGui();
            }
        };
        this.playerMessage.setChecked(this.getLootSetting(LootSettings::hasMessage).orElse(false));
        this.addGuiElement(this.playerMessage);
        totalHeight += 20;
        if (this.playerMessage.checked()) {
            totalHeight = this.addPlayerMessageElements(totalHeight);
        }
    }

    private static class PotionEffectElement
    extends Composite {
        private PotionEffect potionEffect;

        private PotionEffectElement(int topLeftX, int topLeftY, PotionEffect effect, final GuiContainerBase parent, final Consumer<PotionEffect> onEffectUpdated) {
            super(parent, topLeftX, topLeftY, 230, 12);
            this.potionEffect = effect;
            Button selectEffect = new Button(0, 0, 160, 12, this.potionEffect.func_188419_a().getRegistryName().toString()){

                @Override
                protected void onPressed() {
                    Minecraft.func_71410_x().func_147108_a(new GuiSelectFromList<String>(parent, this.text, s -> s, () -> this.getEffectNames(), s -> {
                        this.setText((String)s);
                        potionEffect = new PotionEffect((Potion)Potion.field_188414_b.func_82594_a((Object)new ResourceLocation(s)), potionEffect.func_76459_b(), potionEffect.func_76458_c());
                        onEffectUpdated.accept(potionEffect);
                        parent.refreshGui();
                    }));
                }
            };
            this.addGuiElement(selectEffect);
            NumberInput duration = new NumberInput(170, 0, 22, (float)this.potionEffect.func_76459_b() / 20.0f, parent){

                @Override
                public void onValueUpdated(float value) {
                    potionEffect = new PotionEffect(potionEffect.func_188419_a(), (int)value * 20, potionEffect.func_76458_c());
                    onEffectUpdated.accept(potionEffect);
                }
            };
            duration.setIntegerValue();
            this.addGuiElement(duration);
            NumberInput amplifier = new NumberInput(200, 0, 15, this.potionEffect.func_76458_c(), parent){

                @Override
                public void onValueUpdated(float value) {
                    potionEffect = new PotionEffect(potionEffect.func_188419_a(), potionEffect.func_76459_b(), (int)value);
                    onEffectUpdated.accept(potionEffect);
                }
            };
            amplifier.setIntegerValue();
            this.addGuiElement(amplifier);
        }

        @Override
        protected int getPaddingY() {
            return 0;
        }

        @Override
        protected int getPaddingX() {
            return 0;
        }

        @Override
        protected boolean drawBackground() {
            return false;
        }

        private List<String> getEffectNames() {
            return Potion.field_188414_b.func_148742_b().stream().map(ResourceLocation::toString).sorted(Comparator.naturalOrder()).collect(Collectors.toList());
        }
    }
}

