/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gui;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.Checkbox;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;
import net.shadowmage.ancientwarfare.structure.container.ContainerStructureScanner;
import net.shadowmage.ancientwarfare.structure.gui.GuiStructureScanner;

public class GuiDimensionSelection
extends GuiContainerBase {
    private final GuiStructureScanner parent;
    private CompositeScrolled area;
    private Checkbox whiteList;
    private NumberInput dimensionSelection;
    private Set<Integer> dims = new HashSet<Integer>();

    public GuiDimensionSelection(GuiStructureScanner parent) {
        super(new ContainerBase(((ContainerStructureScanner)((Object)parent.getContainer())).player));
        this.parent = parent;
        this.shouldCloseOnVanillaKeys = false;
        for (int dim : ((ContainerStructureScanner)((Object)parent.getContainer())).getValidator().getAcceptedDimensions()) {
            this.dims.add(dim);
        }
    }

    @Override
    public void initElements() {
        Label label = new Label(8, 8, I18n.func_135052_a((String)"guistrings.select_dimensions", (Object[])new Object[0]) + ":");
        this.addGuiElement(label);
        this.area = new CompositeScrolled(this, 0, 40, 256, 200);
        this.addGuiElement(this.area);
        Button button = new Button(193, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                GuiDimensionSelection.this.closeGui();
            }
        };
        this.addGuiElement(button);
        this.whiteList = new Checkbox(8, 20, 16, 16, "guistrings.dimension_whitelist"){

            @Override
            public void onToggled() {
                ((ContainerStructureScanner)((Object)GuiDimensionSelection.this.parent.getContainer())).updateValidator(v -> v.setDimensionWhiteList(this.checked()));
            }
        };
        this.addGuiElement(this.whiteList);
        this.whiteList.setChecked(((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().isDimensionWhiteList());
        this.dimensionSelection = new NumberInput(140, 22, 35, 0.0f, (IWidgetSelection)this);
        this.dimensionSelection.setIntegerValue();
        this.dimensionSelection.setAllowNegative();
        button = new Button(179, 22, 12, 12, "+"){

            @Override
            protected void onPressed() {
                int num = GuiDimensionSelection.this.dimensionSelection.getIntegerValue();
                GuiDimensionSelection.this.dims.add(num);
                ((ContainerStructureScanner)((Object)GuiDimensionSelection.this.parent.getContainer())).updateValidator(v -> v.setValidDimension(GuiDimensionSelection.this.dims));
                GuiDimensionSelection.this.refreshGui();
            }
        };
        this.addGuiElement(button);
        this.addGuiElement(this.dimensionSelection);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        this.whiteList.setChecked(((ContainerStructureScanner)((Object)this.parent.getContainer())).getValidator().isDimensionWhiteList());
        int totalHeight = 8;
        for (Integer dim : this.dims) {
            this.area.addGuiElement(new DimensionButton(8, totalHeight, 232, 12, dim));
            totalHeight += 12;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        Minecraft.func_71410_x().func_147108_a((GuiScreen)this.parent);
        return false;
    }

    private class DimensionButton
    extends Button {
        final int dim;

        public DimensionButton(int topLeftX, int topLeftY, int width, int height, int dim) {
            super(topLeftX, topLeftY, width, height, I18n.func_135052_a((String)"guistrings.dimension", (Object[])new Object[]{dim}));
            this.dim = dim;
        }

        @Override
        protected void onPressed() {
            GuiDimensionSelection.this.dims.remove(this.dim);
            ((ContainerStructureScanner)((Object)GuiDimensionSelection.this.parent.getContainer())).updateValidator(v -> v.setValidDimension(GuiDimensionSelection.this.dims));
            GuiDimensionSelection.this.refreshGui();
        }
    }
}

