/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gates.types;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.StreamSupport;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.AncientWarfareStructure;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.entity.DualBoundingBox;
import net.shadowmage.ancientwarfare.structure.entity.EntityGate;
import net.shadowmage.ancientwarfare.structure.gates.IGateType;
import net.shadowmage.ancientwarfare.structure.gates.types.GateDouble;
import net.shadowmage.ancientwarfare.structure.gates.types.GateRotatingBridge;
import net.shadowmage.ancientwarfare.structure.gates.types.GateSingle;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.init.AWStructureItems;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;
import net.shadowmage.ancientwarfare.structure.tile.TEGateProxy;

public class Gate
implements IGateType {
    private static final Gate[] gateTypes = new Gate[16];
    private static final Gate basicWood = new Gate(0, "_wood_1.png", AWStructureSounds.WOODEN_GATE, SoundEvents.field_187927_ha, AWStructureSounds.WOODEN_GATE_BREAK, AWStructureStatics.gateVerticalWoodenMaxHealth).setName("gateBasicWood").setVariant(Variant.WOOD_BASIC);
    private static final Gate basicIron = new Gate(1, "_iron_1.png", AWStructureSounds.IRON_GATE, SoundEvents.field_187928_hb, AWStructureSounds.IRON_GATE_BREAK, AWStructureStatics.gateVerticalIronMaxHealth).setName("gateBasicIron").setVariant(Variant.IRON_BASIC).setModel(1);
    private static final Gate singleWood = new GateSingle(4, "_wood_1.png", AWStructureSounds.WOODEN_GATE, SoundEvents.field_187927_ha, AWStructureSounds.WOODEN_GATE_BREAK, AWStructureStatics.gateSingleWoodMaxHealth).setName("gateSingleWood").setVariant(Variant.WOOD_SINGLE);
    private static final Gate singleIron = new GateSingle(5, "_iron_1.png", AWStructureSounds.IRON_GATE, SoundEvents.field_187928_hb, AWStructureSounds.IRON_GATE_BREAK, AWStructureStatics.gateSingleIronMaxHealth).setName("gateSingleIron").setVariant(Variant.IRON_SINGLE).setModel(1);
    private static final Gate doubleWood = new GateDouble(8, "_wood_1.png", AWStructureSounds.WOODEN_GATE, SoundEvents.field_187927_ha, AWStructureSounds.WOODEN_GATE_BREAK, AWStructureStatics.gateDoubleWoodMaxHealth).setName("gateDoubleWood").setVariant(Variant.WOOD_DOUBLE);
    private static final Gate doubleIron = new GateDouble(9, "_iron_1.png", AWStructureSounds.IRON_GATE, SoundEvents.field_187928_hb, AWStructureSounds.IRON_GATE_BREAK, AWStructureStatics.gateDoubleIronMaxHealth).setName("gateDoubleIron").setVariant(Variant.IRON_DOUBLE).setModel(1);
    private static final Gate rotatingBridge = new GateRotatingBridge(12, "_bridge_wood_1.png", AWStructureSounds.WOODEN_GATE, SoundEvents.field_187927_ha, AWStructureSounds.WOODEN_GATE_BREAK, AWStructureStatics.drawbridgeMaxHealth);
    private static final HashMap<String, Integer> gateIDByName = new HashMap();
    private final int globalID;
    protected String displayName = "";
    protected String tooltip = "";
    protected Variant variant;
    protected int maxHealth = 80;
    private int modelType = 0;
    public SoundEvent moveSound;
    public SoundEvent hurtSound;
    public SoundEvent breakSound;
    protected boolean canSoldierInteract = true;
    protected float moveSpeed = 0.025f;
    private final ItemStack displayStack;
    private ResourceLocation textureLocation;
    private ResourceLocation textureLocationHurt;

    public Variant getVariant() {
        return this.variant;
    }

    public boolean isWood(Variant variant) {
        switch (variant) {
            case WOOD_DOUBLE: 
            case WOOD_ROTATING: 
            case WOOD_SINGLE: 
            case WOOD_BASIC: {
                return true;
            }
        }
        return false;
    }

    public Gate(int id, String textureLocation, SoundEvent moveSound, SoundEvent hurtSound, SoundEvent breakSound, int maxHealth) {
        this.globalID = id;
        this.tooltip = "item.gate." + id + ".tooltip";
        if (id >= 0 && id < gateTypes.length && gateTypes[id] == null) {
            Gate.gateTypes[id] = this;
        }
        this.displayStack = new ItemStack((Item)AWStructureItems.GATE_SPAWNER, 1, id);
        this.textureLocation = new ResourceLocation("ancientwarfare:textures/model/structure/gate/gate" + textureLocation);
        this.textureLocationHurt = new ResourceLocation("ancientwarfare:textures/model/structure/gate/gate_wood_1_damaged_2.png");
        this.moveSound = moveSound;
        this.hurtSound = hurtSound;
        this.breakSound = breakSound;
        this.maxHealth = maxHealth;
    }

    protected final Gate setName(String name) {
        this.displayName = name;
        return this;
    }

    protected final Gate setVariant(Variant variant) {
        this.variant = variant;
        return this;
    }

    protected final Gate setModel(int type) {
        this.modelType = type;
        return this;
    }

    @Override
    public int getGlobalID() {
        return this.globalID;
    }

    @Override
    public int getModelType() {
        return this.modelType;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    @Override
    public String getTooltip() {
        return this.tooltip;
    }

    @Override
    public ItemStack getConstructingItem() {
        return new ItemStack((Item)AWStructureItems.GATE_SPAWNER, 1, this.globalID);
    }

    @Override
    public ItemStack getDisplayStack() {
        return this.displayStack;
    }

    @Override
    public int getMaxHealth() {
        return this.maxHealth;
    }

    @Override
    public float getMoveSpeed() {
        return this.moveSpeed;
    }

    @Override
    public ResourceLocation getTexture() {
        return this.textureLocation;
    }

    @Override
    public boolean canActivate(EntityGate gate, boolean open) {
        return true;
    }

    @Override
    public boolean canSoldierActivate() {
        return this.canSoldierInteract;
    }

    public static String getGateNameFor(EntityGate gate) {
        int id = gate.getGateType().getGlobalID();
        return Gate.getGateNameFor(id);
    }

    private static String getGateNameFor(int id) {
        for (Map.Entry<String, Integer> entry : gateIDByName.entrySet()) {
            int gateID = entry.getValue();
            if (gateID != id) continue;
            return entry.getKey();
        }
        return "gate.verticalWooden";
    }

    public static Gate getGateByName(String name) {
        if (gateIDByName.containsKey(name)) {
            return Gate.getGateByID(gateIDByName.get(name));
        }
        return basicWood;
    }

    public static Gate getGateByID(int id) {
        if (id >= 0 && id < gateTypes.length) {
            return gateTypes[id];
        }
        return basicWood;
    }

    public void updateRenderBoundingBox(EntityGate gate) {
        if (gate.func_184177_bl().func_72320_b() == 0.0) {
            BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
            BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
            gate.setRenderBoundingBox(this.getRenderBoundingBox(gate, min, max));
        }
    }

    protected AxisAlignedBB getRenderBoundingBox(EntityGate gate, BlockPos min, BlockPos max) {
        return new AxisAlignedBB(min, max.func_177982_a(1, 1, 1));
    }

    @Override
    public void setCollisionBoundingBox(EntityGate gate) {
        if (gate.pos1 == null || gate.pos2 == null) {
            return;
        }
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        if (!(gate.func_174813_aQ() instanceof DualBoundingBox)) {
            try {
                ObfuscationReflectionHelper.setPrivateValue(Entity.class, (Object)gate, (Object)((Object)new DualBoundingBox(min, max)), (String[])new String[]{"boundingBox", "field_70121_D"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (gate.edgePosition > 0.0f) {
            gate.func_174826_a(new AxisAlignedBB((double)min.func_177958_n(), (double)max.func_177956_o() + 0.5, (double)min.func_177952_p(), (double)(max.func_177958_n() + 1), (double)(max.func_177956_o() + 1), (double)(max.func_177952_p() + 1)));
        } else {
            gate.func_174826_a(new AxisAlignedBB((double)min.func_177958_n(), (double)min.func_177956_o(), (double)min.func_177952_p(), (double)(max.func_177958_n() + 1), (double)(max.func_177956_o() + 1), (double)(max.func_177952_p() + 1)));
        }
    }

    @Override
    public boolean arePointsValidPair(BlockPos pos1, BlockPos pos2) {
        return pos1.func_177958_n() == pos2.func_177958_n() || pos1.func_177952_p() == pos2.func_177952_p();
    }

    @Override
    public void setInitialBounds(EntityGate gate, BlockPos pos1, BlockPos pos2) {
        BlockPos min = BlockTools.getMin(pos1, pos2);
        BlockPos max = BlockTools.getMax(pos1, pos2);
        boolean wideOnXAxis = min.func_177958_n() != max.func_177958_n();
        float width = wideOnXAxis ? (float)(max.func_177958_n() - min.func_177958_n() + 1) : (float)(max.func_177952_p() - min.func_177952_p() + 1);
        float xOffset = wideOnXAxis ? width * 0.5f : 0.5f;
        float zOffset = wideOnXAxis ? 0.5f : width * 0.5f;
        gate.setPositions(min, max);
        gate.setRenderBoundingBox(this.getRenderBoundingBox(gate, min, max));
        gate.edgeMax = (float)max.func_177956_o() - (float)min.func_177956_o() + 1.0f;
        gate.func_70107_b((float)min.func_177958_n() + xOffset, min.func_177956_o(), (float)min.func_177952_p() + zOffset);
    }

    @Override
    public void onGateFinishOpen(EntityGate gate) {
    }

    @Override
    public void onGateStartClose(EntityGate gate) {
    }

    @Override
    public void onGateFinishClose(EntityGate gate) {
        if (gate.field_70170_p.field_72995_K) {
            return;
        }
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        this.closeBetween(gate, min, max);
    }

    final void closeBetween(EntityGate gate, BlockPos min, BlockPos max) {
        BlockPos.func_177980_a((BlockPos)min, (BlockPos)max).forEach(pos -> {
            this.placeProxyIfNotPresent(gate, (BlockPos)pos);
            if (!gate.getRenderedTilePos().isPresent()) {
                WorldTools.getTile((IBlockAccess)gate.field_70170_p, pos, TEGateProxy.class).ifPresent(te -> {
                    te.setRender();
                    gate.setRenderedTilePos((BlockPos)pos);
                });
            }
        });
    }

    public void setRenderedTileIfNotPresent(EntityGate gate) {
        if (gate.getRenderedTilePos().isPresent()) {
            return;
        }
        BlockPos min = BlockTools.getMin(gate.pos1, gate.pos2);
        BlockPos max = BlockTools.getMax(gate.pos1, gate.pos2);
        BlockPos.func_177980_a((BlockPos)min, (BlockPos)max).forEach(pos -> this.placeProxyIfNotPresent(gate, (BlockPos)pos));
        Optional<TEGateProxy> renderedTe = StreamSupport.stream(BlockPos.func_177980_a((BlockPos)min, (BlockPos)max).spliterator(), false).map(pos -> WorldTools.getTile((IBlockAccess)gate.field_70170_p, pos, TEGateProxy.class)).filter(te -> te.isPresent() && ((TEGateProxy)((Object)((Object)te.get()))).doesRender()).map(Optional::get).findFirst();
        if (renderedTe.isPresent()) {
            gate.setRenderedTilePos(renderedTe.get().func_174877_v());
        } else {
            WorldTools.getTile((IBlockAccess)gate.field_70170_p, min, TEGateProxy.class).ifPresent(te -> {
                te.setRender();
                gate.setRenderedTilePos(min);
            });
        }
    }

    private void placeProxyIfNotPresent(EntityGate gate, BlockPos pos) {
        IBlockState state = gate.field_70170_p.func_180495_p(pos);
        Block block = state.func_177230_c();
        if (block != AWStructureBlocks.GATE_PROXY) {
            if (!gate.field_70170_p.func_175623_d(pos)) {
                block.func_176226_b(gate.field_70170_p, pos, state, 0);
            }
            gate.field_70170_p.func_175656_a(pos, AWStructureBlocks.GATE_PROXY.func_176223_P());
        }
        WorldTools.getTile((IBlockAccess)gate.field_70170_p, pos, TEGateProxy.class).ifPresent(t -> t.setOwner(gate));
    }

    public static Optional<EntityGate> constructGate(World world, BlockPos pos1, BlockPos pos2, Gate type, EnumFacing facing, Owner owner) {
        BlockPos min = BlockTools.getMin(pos1, pos2);
        BlockPos max = BlockTools.getMax(pos1, pos2);
        for (int x = min.func_177958_n(); x <= max.func_177958_n(); ++x) {
            for (int y = min.func_177956_o(); y <= max.func_177956_o(); ++y) {
                for (int z = min.func_177952_p(); z <= max.func_177952_p(); ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    if (world.func_175623_d(pos)) continue;
                    AncientWarfareStructure.LOG.info("could not create gate for non-air block at: {},{},{} block: {}", (Object)x, (Object)y, (Object)z, (Object)world.func_180495_p(pos).func_177230_c());
                    return Optional.empty();
                }
            }
        }
        EnumFacing rotatedFacing = facing;
        if (pos1.func_177958_n() == pos2.func_177958_n()) {
            if (facing == EnumFacing.SOUTH || facing == EnumFacing.NORTH) {
                rotatedFacing = facing.func_176746_e();
            }
        } else if (pos1.func_177952_p() == pos2.func_177952_p() && (facing == EnumFacing.EAST || facing == EnumFacing.WEST)) {
            rotatedFacing = facing.func_176746_e();
        }
        EntityGate ent = new EntityGate(world);
        ent.setGateType(type);
        ent.gateOrientation = rotatedFacing;
        type.setInitialBounds(ent, pos1, pos2);
        type.onGateFinishClose(ent);
        ent.setOwner(owner);
        return Optional.of(ent);
    }

    public static ItemStack getItemToConstruct(int type) {
        return Gate.getGateByID(type).getConstructingItem();
    }

    static {
        gateIDByName.put("gate.verticalWooden", 0);
        gateIDByName.put("gate.verticalIron", 1);
        gateIDByName.put("gate.singleWood", 4);
        gateIDByName.put("gate.singleIron", 5);
        gateIDByName.put("gate.doubleWood", 8);
        gateIDByName.put("gate.doubleIron", 9);
        gateIDByName.put("gate.drawbridge", 12);
    }

    public static enum Variant {
        WOOD_BASIC,
        IRON_BASIC,
        WOOD_SINGLE,
        IRON_SINGLE,
        WOOD_DOUBLE,
        IRON_DOUBLE,
        WOOD_ROTATING;

    }
}

