/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.gamedata;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.storage.WorldSavedData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.util.Zone;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.structure.gamedata.StructureEntry;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureEntry;
import net.shadowmage.ancientwarfare.structure.util.ConquerHelper;

public class StructureMap
extends WorldSavedData {
    private static final Cache<Zone, Set<StructureEntry>> CHUNK_STRUCTURE_ENTRIES = CacheBuilder.newBuilder().expireAfterAccess(10L, TimeUnit.MINUTES).build();
    private StructureDimensionMap map = new StructureDimensionMap();

    public StructureMap(String name) {
        super(name);
    }

    public void func_76184_a(NBTTagCompound nbttagcompound) {
        NBTTagCompound mapTag = nbttagcompound.func_74775_l("map");
        this.map.readFromNBT(this, mapTag);
    }

    public NBTTagCompound func_189551_b(NBTTagCompound nbttagcompound) {
        NBTTagCompound mapTag = new NBTTagCompound();
        this.map.writeToNBT(mapTag);
        nbttagcompound.func_74782_a("map", (NBTBase)mapTag);
        return nbttagcompound;
    }

    public boolean shouldPreventSpawnAtPos(World world, BlockPos pos) {
        boolean preventSpawn = false;
        for (StructureEntry entry : this.getStructuresInChunk(world, pos)) {
            if (!entry.getBB().contains(pos) || !entry.shouldPreventNaturalHostileSpawns() || entry.getConquered()) continue;
            if (entry.hasProtectionFlag() || ConquerHelper.checkBBNotConquered(world, entry.getBB())) {
                return true;
            }
            entry.setConquered();
        }
        return preventSpawn;
    }

    private Set<StructureEntry> getStructuresInChunk(World world, BlockPos pos) {
        Set structures;
        ChunkPos chunkPos = new ChunkPos(pos);
        BlockPos min = new BlockPos(chunkPos.field_77276_a * 16, 1, chunkPos.field_77275_b * 16);
        BlockPos max = new BlockPos(chunkPos.field_77276_a * 16 + 15, 255, chunkPos.field_77275_b * 16 + 15);
        Zone chunkZone = new Zone(min, max);
        try {
            structures = (Set)CHUNK_STRUCTURE_ENTRIES.get((Object)chunkZone, () -> this.getStructuresIn(world, chunkZone));
        }
        catch (ExecutionException e) {
            AncientWarfareNPC.LOG.error("Error getting structure entries in chunk for hostile entity check: ", (Throwable)e);
            return new HashSet<StructureEntry>();
        }
        return structures;
    }

    public Collection<StructureEntry> getEntriesNear(World world, int worldX, int worldZ, int chunkRadius, boolean expandBySize, Collection<StructureEntry> list) {
        int cx = worldX >> 4;
        int cz = worldZ >> 4;
        return this.map.getEntriesNear(world.field_73011_w.getDimension(), cx, cz, chunkRadius, expandBySize, list);
    }

    private Set<StructureEntry> getStructuresIn(World world, Zone zone) {
        HashSet<StructureEntry> ret = new HashSet<StructureEntry>();
        for (StructureEntry structure : this.getEntriesNear(world, zone.min.func_177958_n(), zone.min.func_177952_p(), 1, true, new ArrayList<StructureEntry>())) {
            if (!structure.getBB().intersects(zone)) continue;
            ret.add(structure);
        }
        return ret;
    }

    public Optional<StructureEntry> getStructureAt(World world, BlockPos pos) {
        for (StructureEntry structure : this.getEntriesNear(world, pos.func_177958_n(), pos.func_177952_p(), 1, true, new ArrayList<StructureEntry>())) {
            if (!structure.getBB().contains(pos)) continue;
            return Optional.of(structure);
        }
        return Optional.empty();
    }

    public Optional<StructureEntry> getStructureAt(World world, int chunkX, int chunkZ) {
        return this.map.getEntryAt(world.field_73011_w.getDimension(), chunkX, chunkZ);
    }

    public void setGeneratedAt(World world, int worldX, int worldZ, StructureEntry entry, boolean unique) {
        entry.setStructureMap(this);
        int cx = worldX >> 4;
        int cz = worldZ >> 4;
        int dimension = world.field_73011_w.getDimension();
        this.setGeneratedAt(dimension, cx, cz, entry, unique);
    }

    public void setGeneratedAt(int dimension, int cx, int cz, StructureEntry entry, boolean unique) {
        entry.setStructureMap(this);
        this.map.setGeneratedAt(dimension, cx, cz, entry, unique);
        this.func_76185_a();
        NetworkHandler.sendToAllPlayers(new PacketStructureEntry(dimension, cx, cz, entry));
    }

    public boolean isGeneratedUnique(String name) {
        return this.map.generatedUniques.contains(name);
    }

    private static class StructureWorldMap {
        private HashMap<Integer, HashMap<Integer, StructureEntry>> worldMap = new HashMap();
        private int largestGeneratedX;
        private int largestGeneratedZ;

        private StructureWorldMap() {
        }

        public Collection<StructureEntry> getEntriesNear(int chunkX, int chunkZ, int chunkRadius, boolean expandBySize, Collection<StructureEntry> list) {
            int crx = chunkRadius;
            int crz = chunkRadius;
            if (expandBySize) {
                crx += this.largestGeneratedX / 16;
                crz += this.largestGeneratedZ / 16;
            }
            for (int x = chunkX - crx; x <= chunkX + crx; ++x) {
                if (!this.worldMap.containsKey(x)) continue;
                for (int z = chunkZ - crz; z <= chunkZ + crz; ++z) {
                    StructureEntry entry = this.worldMap.get(x).get(z);
                    if (entry == null) continue;
                    list.add(entry);
                }
            }
            return list;
        }

        public void setGeneratedAt(int chunkX, int chunkZ, StructureEntry entry) {
            if (!this.worldMap.containsKey(chunkX)) {
                this.worldMap.put(chunkX, new HashMap());
            }
            this.worldMap.get(chunkX).put(chunkZ, entry);
            int x = entry.bb.getXSize();
            int z = entry.bb.getZSize();
            if (x > this.largestGeneratedX) {
                this.largestGeneratedX = x;
            }
            if (z > this.largestGeneratedZ) {
                this.largestGeneratedZ = z;
            }
        }

        public Optional<StructureEntry> getEntryAt(int chunkX, int chunkZ) {
            if (!this.worldMap.containsKey(chunkX)) {
                return Optional.empty();
            }
            return Optional.ofNullable(this.worldMap.get(chunkX).get(chunkZ));
        }

        public void readFromNBT(StructureMap structureMap, NBTTagCompound nbttagcompound) {
            NBTTagList entryList = nbttagcompound.func_150295_c("entries", 10);
            for (int i = 0; i < entryList.func_74745_c(); ++i) {
                NBTTagCompound entryTag = entryList.func_150305_b(i);
                int x = entryTag.func_74762_e("x");
                int z = entryTag.func_74762_e("z");
                StructureEntry entry = new StructureEntry();
                entry.setStructureMap(structureMap);
                entry.readFromNBT(entryTag);
                if (!this.worldMap.containsKey(x)) {
                    this.worldMap.put(x, new HashMap());
                }
                this.worldMap.get(x).put(z, entry);
            }
            this.largestGeneratedX = nbttagcompound.func_74762_e("largestX");
            this.largestGeneratedZ = nbttagcompound.func_74762_e("largestZ");
        }

        public void writeToNBT(NBTTagCompound nbttagcompound) {
            NBTTagList entryList = new NBTTagList();
            for (Map.Entry<Integer, HashMap<Integer, StructureEntry>> x : this.worldMap.entrySet()) {
                for (Map.Entry<Integer, StructureEntry> z : x.getValue().entrySet()) {
                    NBTTagCompound entryTag = new NBTTagCompound();
                    entryTag.func_74768_a("x", x.getKey().intValue());
                    entryTag.func_74768_a("z", z.getKey().intValue());
                    z.getValue().writeToNBT(entryTag);
                    entryList.func_74742_a((NBTBase)entryTag);
                }
            }
            nbttagcompound.func_74768_a("largestX", this.largestGeneratedX);
            nbttagcompound.func_74768_a("largestZ", this.largestGeneratedZ);
            nbttagcompound.func_74782_a("entries", (NBTBase)entryList);
        }
    }

    private static class StructureDimensionMap {
        private HashMap<Integer, StructureWorldMap> mapsByDimension = new HashMap();
        private Set<String> generatedUniques = new HashSet<String>();

        private StructureDimensionMap() {
        }

        private Collection<StructureEntry> getEntriesNear(int dimension, int chunkX, int chunkZ, int chunkRadius, boolean expandBySize, Collection<StructureEntry> list) {
            if (this.mapsByDimension.containsKey(dimension)) {
                return this.mapsByDimension.get(dimension).getEntriesNear(chunkX, chunkZ, chunkRadius, expandBySize, list);
            }
            return Collections.emptyList();
        }

        private Optional<StructureEntry> getEntryAt(int dimension, int chunkX, int chunkZ) {
            if (!this.mapsByDimension.containsKey(dimension)) {
                return Optional.empty();
            }
            return this.mapsByDimension.get(dimension).getEntryAt(chunkX, chunkZ);
        }

        private void setGeneratedAt(int dimension, int chunkX, int chunkZ, StructureEntry entry, boolean unique) {
            if (!this.mapsByDimension.containsKey(dimension)) {
                this.mapsByDimension.put(dimension, new StructureWorldMap());
            }
            this.mapsByDimension.get(dimension).setGeneratedAt(chunkX, chunkZ, entry);
            if (unique) {
                this.generatedUniques.add(entry.name);
            }
        }

        public void readFromNBT(StructureMap structureMap, NBTTagCompound nbttagcompound) {
            int i;
            NBTTagList uniquesList = nbttagcompound.func_150295_c("uniques", 8);
            NBTTagList dimensionList = nbttagcompound.func_150295_c("dimensions", 10);
            for (i = 0; i < dimensionList.func_74745_c(); ++i) {
                NBTTagCompound dimensionTag = dimensionList.func_150305_b(i);
                int dim = dimensionTag.func_74762_e("dim");
                if (!this.mapsByDimension.containsKey(dim)) {
                    this.mapsByDimension.put(dim, new StructureWorldMap());
                }
                this.mapsByDimension.get(dim).readFromNBT(structureMap, dimensionTag.func_74775_l("data"));
            }
            for (i = 0; i < uniquesList.func_74745_c(); ++i) {
                this.generatedUniques.add(uniquesList.func_150307_f(i));
            }
        }

        public void writeToNBT(NBTTagCompound nbttagcompound) {
            NBTTagList dimensionsList = new NBTTagList();
            NBTTagList uniquesList = new NBTTagList();
            for (Map.Entry<Integer, StructureWorldMap> dim : this.mapsByDimension.entrySet()) {
                NBTTagCompound dimensionTag = new NBTTagCompound();
                NBTTagCompound dimensionData = new NBTTagCompound();
                dimensionTag.func_74768_a("dim", dim.getKey().intValue());
                dim.getValue().writeToNBT(dimensionData);
                dimensionTag.func_74782_a("data", (NBTBase)dimensionData);
                dimensionsList.func_74742_a((NBTBase)dimensionTag);
            }
            for (String name : this.generatedUniques) {
                uniquesList.func_74742_a((NBTBase)new NBTTagString(name));
            }
            nbttagcompound.func_74782_a("dimensions", (NBTBase)dimensionsList);
            nbttagcompound.func_74782_a("uniques", (NBTBase)uniquesList);
        }
    }
}

