/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.entity;

import io.netty.buffer.ByteBuf;
import java.util.Optional;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemAxe;
import net.minecraft.item.ItemPickaxe;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.scoreboard.Team;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.interfaces.IEntityPacketHandler;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketEntity;
import net.shadowmage.ancientwarfare.core.owner.Owner;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.structure.gates.types.Gate;
import net.shadowmage.ancientwarfare.structure.gates.types.GateRotatingBridge;

public class EntityGate
extends Entity
implements IEntityAdditionalSpawnData,
IEntityPacketHandler {
    private static final String HEALTH_TAG = "health";
    public BlockPos pos1;
    public BlockPos pos2;
    public float edgePosition;
    public float edgeMax;
    public float openingSpeed = 0.0f;
    public Gate gateType = Gate.getGateByID(0);
    private Owner owner = Owner.EMPTY;
    private int health = 0;
    public int hurtAnimationTicks = 0;
    private byte gateStatus = 0;
    public EnumFacing gateOrientation = EnumFacing.SOUTH;
    private int hurtInvulTicks = 0;
    private boolean hasSetWorldEntityRadius = false;
    private boolean wasPoweredA = false;
    private boolean wasPoweredB = false;
    private AxisAlignedBB renderBoundingBox = new AxisAlignedBB(0.0, 0.0, 0.0, 0.0, 0.0, 0.0);
    private BlockPos renderedTilePos = null;
    private int soundTicks = 15;

    public EntityGate(World par1World) {
        super(par1World);
        this.field_70158_ak = true;
        this.field_70156_m = true;
    }

    public void setOwner(Owner owner) {
        this.owner = owner;
    }

    public void setOwner(EntityPlayer player) {
        this.owner = new Owner(player);
    }

    public void setPositions(BlockPos pos1, BlockPos pos2) {
        this.pos1 = pos1;
        this.pos2 = pos2;
    }

    public Team func_96124_cp() {
        return this.field_70170_p.func_96441_U().func_96509_i(this.getOwner().getName());
    }

    public Gate getGateType() {
        return this.gateType;
    }

    public void setGateType(Gate type) {
        this.gateType = type;
        this.setHealth(type.getMaxHealth());
    }

    protected void func_70088_a() {
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return Gate.getItemToConstruct(this.gateType.getGlobalID());
    }

    public void repackEntity() {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return;
        }
        this.gateType.onGateStartClose(this);
        ItemStack item = Gate.getItemToConstruct(this.gateType.getGlobalID());
        EntityItem entity = new EntityItem(this.field_70170_p, this.field_70165_t, this.field_70163_u + 0.5, this.field_70161_v, item);
        this.field_70170_p.func_72838_d((Entity)entity);
        this.func_70106_y();
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (!this.field_70170_p.field_72995_K) {
            this.gateType.onGateStartClose(this);
            this.func_184185_a(this.gateType.breakSound, 1.0f, 1.0f);
        }
    }

    private void setOpeningStatus(byte op) {
        this.gateStatus = op;
        if (!this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72960_a((Entity)this, op);
        }
        if (op == -1) {
            this.gateType.onGateStartClose(this);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        int i = MathHelper.func_76128_c((double)this.field_70165_t);
        int j = MathHelper.func_76128_c((double)this.field_70161_v);
        int k = MathHelper.func_76128_c((double)this.field_70163_u);
        if (this.pos1.func_177956_o() > k) {
            k = this.pos1.func_177956_o();
        }
        if (this.pos2.func_177956_o() > k) {
            k = this.pos2.func_177956_o();
        }
        return this.field_70170_p.func_175626_b(new BlockPos(i, k, j), 0);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte par1) {
        if (par1 == -1 || par1 == 0 || par1 == 1) {
            this.setOpeningStatus(par1);
        }
        super.func_70103_a(par1);
    }

    public boolean isClosed() {
        return this.gateStatus == 0 && this.edgePosition == 0.0f;
    }

    public byte getOpeningStatus() {
        return this.gateStatus;
    }

    public int getHealth() {
        return this.health;
    }

    public void setHealth(int val) {
        int newHealth = Math.max(val, 0);
        if (newHealth < this.health) {
            this.hurtAnimationTicks = 20;
        }
        if (newHealth < this.health && !this.field_70170_p.field_72995_K) {
            PacketEntity pkt = new PacketEntity(this);
            pkt.packetData.func_74768_a(HEALTH_TAG, newHealth);
            NetworkHandler.sendToAllTracking(this, pkt);
        }
        this.health = newHealth;
    }

    public void func_70107_b(double par1, double par3, double par5) {
        this.field_70165_t = par1;
        this.field_70163_u = par3;
        this.field_70161_v = par5;
        if (this.gateType != null) {
            this.gateType.setCollisionBoundingBox(this);
        }
    }

    public boolean func_184230_a(EntityPlayer player, EnumHand hand) {
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        boolean gateOwner = this.getOwner().isOwnerOrSameTeamOrFriend((Entity)player);
        if (player.field_71075_bZ.field_75098_d || this.getOwner() == Owner.EMPTY || gateOwner) {
            if (player.func_70093_af()) {
                if (player.field_71075_bZ.field_75098_d) {
                    NetworkHandler.INSTANCE.openGui(player, 58, this.func_145782_y(), 0, 0);
                } else if (gateOwner) {
                    NetworkHandler.INSTANCE.openGui(player, 11, this.func_145782_y(), 0, 0);
                }
            } else {
                this.activateGate();
            }
            return true;
        }
        player.func_145747_a((ITextComponent)new TextComponentTranslation("guistrings.gate.use_error", new Object[0]));
        return false;
    }

    public void activateGate() {
        if (this.gateStatus == 1 && this.gateType.canActivate(this, false)) {
            this.setOpeningStatus((byte)-1);
        } else if (this.gateStatus == -1 && this.gateType.canActivate(this, true)) {
            this.setOpeningStatus((byte)1);
        } else if (this.edgePosition == 0.0f && this.gateType.canActivate(this, true)) {
            this.setOpeningStatus((byte)1);
        } else if (this.gateType.canActivate(this, false)) {
            this.setOpeningStatus((byte)-1);
        }
    }

    private void playGateMoveSound(BlockPos pos, Gate gateType) {
        this.field_70170_p.func_184133_a(null, pos, gateType.moveSound, SoundCategory.AMBIENT, 2.0f, 1.0f);
        this.soundTicks = 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float prevEdge = this.edgePosition;
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (this.hurtInvulTicks > 0) {
            --this.hurtInvulTicks;
        }
        this.checkForPowerUpdates();
        this.gateType.setRenderedTileIfNotPresent(this);
        if (this.hurtAnimationTicks > 0) {
            --this.hurtAnimationTicks;
        }
        if (this.gateStatus == 1) {
            this.edgePosition += this.gateType.getMoveSpeed();
            if (this.soundTicks == 15) {
                this.playGateMoveSound(this.pos1, this.gateType);
            }
            ++this.soundTicks;
            if (this.edgePosition >= this.edgeMax) {
                this.edgePosition = this.edgeMax;
                this.gateStatus = 0;
                this.soundTicks = 15;
                this.gateType.onGateFinishOpen(this);
            }
        } else if (this.gateStatus == -1) {
            this.edgePosition -= this.gateType.getMoveSpeed();
            if (this.soundTicks == 15) {
                this.playGateMoveSound(this.pos1, this.gateType);
            }
            ++this.soundTicks;
            if (this.edgePosition <= 0.0f) {
                this.edgePosition = 0.0f;
                this.gateStatus = 0;
                this.soundTicks = 15;
                this.gateType.onGateFinishClose(this);
            }
        }
        this.openingSpeed = prevEdge - this.edgePosition;
        if (!this.hasSetWorldEntityRadius) {
            this.hasSetWorldEntityRadius = true;
            BlockPos min = BlockTools.getMin(this.pos1, this.pos2);
            BlockPos max = BlockTools.getMax(this.pos1, this.pos2);
            int xSize = max.func_177958_n() - min.func_177958_n() + 1;
            int zSize = max.func_177952_p() - min.func_177952_p() + 1;
            int ySize = max.func_177956_o() - min.func_177956_o() + 1;
            int largest = Math.max(xSize, ySize);
            largest = Math.max(largest, zSize);
            if (World.MAX_ENTITY_RADIUS < (double)(largest = largest / 2 + 1)) {
                World.MAX_ENTITY_RADIUS = largest;
            }
        }
    }

    private void checkForPowerUpdates() {
        boolean foundPowerB;
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        boolean activate = false;
        int y = Math.min(this.pos2.func_177956_o(), this.pos1.func_177956_o());
        boolean foundPowerA = this.field_70170_p.func_175687_A(new BlockPos(this.pos1.func_177958_n(), y, this.pos1.func_177952_p())) > 0;
        boolean bl = foundPowerB = this.field_70170_p.func_175687_A(new BlockPos(this.pos2.func_177958_n(), y, this.pos2.func_177952_p())) > 0;
        if (foundPowerA && !this.wasPoweredA) {
            activate = true;
        }
        if (foundPowerB && !this.wasPoweredB) {
            activate = true;
        }
        this.wasPoweredA = foundPowerA;
        this.wasPoweredB = foundPowerB;
        if (activate) {
            this.activateGate();
        }
    }

    private boolean isInsensitiveTo(DamageSource source) {
        return source == DamageSource.field_82728_o || source == DamageSource.field_76367_g || source == DamageSource.field_76369_e || source == DamageSource.field_76379_h || source == DamageSource.field_82729_p || source == DamageSource.field_76368_d || source == DamageSource.field_76366_f;
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        EntityLivingBase entitylivingbase;
        if (this.isInsensitiveTo(damageSource) || amount < 0.0f) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return true;
        }
        if (!damageSource.func_94541_c()) {
            if (this.hurtInvulTicks > 0) {
                return false;
            }
            this.hurtInvulTicks = 10;
        } else {
            amount *= 10.0f;
        }
        this.func_184185_a(this.gateType.hurtSound, 1.0f, 1.0f);
        if (damageSource.func_76364_f() instanceof EntityArrow) {
            return false;
        }
        if (damageSource.func_76364_f() instanceof EntityLivingBase && !(entitylivingbase = (EntityLivingBase)damageSource.func_76364_f()).func_184586_b(EnumHand.MAIN_HAND).func_190926_b()) {
            Item.ToolMaterial material;
            Item heldItem = entitylivingbase.func_184586_b(EnumHand.MAIN_HAND).func_77973_b();
            amount = this.gateType.isWood(this.gateType.getVariant()) ? (heldItem instanceof ItemAxe ? amount / 2.0f : amount / 4.0f) : (heldItem instanceof ItemPickaxe ? ((material = Item.ToolMaterial.valueOf((String)((ItemPickaxe)heldItem).func_77861_e())) == Item.ToolMaterial.DIAMOND ? amount / 2.0f : amount / 3.0f) : (amount /= 4.0f));
        }
        this.setHealth((int)((float)this.getHealth() - amount));
        if (this.getHealth() <= 0) {
            this.func_70106_y();
        }
        return !this.field_70128_L;
    }

    public Entity func_184204_a(int dimension) {
        return this;
    }

    public boolean func_70072_I() {
        return false;
    }

    public void func_191958_b(float strafe, float up, float forward, float friction) {
    }

    public void func_70024_g(double moveX, double moveY, double moveZ) {
    }

    public AxisAlignedBB func_70046_E() {
        return this.func_174813_aQ();
    }

    public boolean func_70067_L() {
        return true;
    }

    public float func_70111_Y() {
        return 0.1f;
    }

    public boolean func_70104_M() {
        return true;
    }

    public void func_70108_f(Entity entity) {
        super.func_70108_f(entity);
        if (this.isInside(entity)) {
            entity.func_70024_g(0.0, (double)(-this.gateStatus) * 0.5, 0.0);
        }
    }

    public void func_70100_b_(EntityPlayer entity) {
        if (this.isInside((Entity)entity)) {
            entity.func_70024_g(0.0, (double)(-this.gateStatus) * 0.5, 0.0);
        }
    }

    private boolean isInside(Entity entity) {
        return this.gateType instanceof GateRotatingBridge && this.func_174813_aQ().func_72326_a(entity.func_174813_aQ());
    }

    public boolean func_184205_a(Entity entityIn, boolean force) {
        return false;
    }

    public String getTexture() {
        return "textures/models/gate/" + this.gateType.getTexture();
    }

    protected void func_70037_a(NBTTagCompound tag) {
        this.setPositions(BlockPos.func_177969_a((long)tag.func_74763_f("pos1")), BlockPos.func_177969_a((long)tag.func_74763_f("pos2")));
        this.realignEntityPosition();
        this.setGateType(Gate.getGateByID(tag.func_74762_e("type")));
        this.owner = Owner.deserializeFromNBT(tag);
        this.edgePosition = tag.func_74760_g("edge");
        this.edgeMax = tag.func_74760_g("edgeMax");
        this.setHealth(tag.func_74762_e(HEALTH_TAG));
        this.gateStatus = tag.func_74771_c("status");
        this.gateOrientation = EnumFacing.field_82609_l[tag.func_74771_c("orient")];
        this.wasPoweredA = tag.func_74767_n("power");
        this.wasPoweredB = tag.func_74767_n("power2");
        this.gateType.updateRenderBoundingBox(this);
    }

    private void realignEntityPosition() {
        BlockPos min = BlockTools.getMin(this.pos1, this.pos2);
        BlockPos max = BlockTools.getMax(this.pos1, this.pos2);
        this.func_70107_b((double)min.func_177958_n() + (double)(max.func_177958_n() - min.func_177958_n() + 1) / 2.0, min.func_177956_o(), (double)min.func_177952_p() + (double)(max.func_177952_p() - min.func_177952_p() + 1) / 2.0);
    }

    protected void func_70014_b(NBTTagCompound tag) {
        tag.func_74772_a("pos1", this.pos1.func_177986_g());
        tag.func_74772_a("pos2", this.pos2.func_177986_g());
        tag.func_74768_a("type", this.gateType.getGlobalID());
        this.getOwner().serializeToNBT(tag);
        tag.func_74776_a("edge", this.edgePosition);
        tag.func_74776_a("edgeMax", this.edgeMax);
        tag.func_74768_a(HEALTH_TAG, this.getHealth());
        tag.func_74774_a("status", this.gateStatus);
        tag.func_74774_a("orient", (byte)this.gateOrientation.ordinal());
        tag.func_74757_a("power", this.wasPoweredA);
        tag.func_74757_a("power2", this.wasPoweredB);
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeLong(this.pos1.func_177986_g());
        data.writeLong(this.pos2.func_177986_g());
        data.writeInt(this.gateType.getGlobalID());
        data.writeFloat(this.edgePosition);
        data.writeFloat(this.edgeMax);
        data.writeByte((int)this.gateStatus);
        data.writeByte(this.gateOrientation.ordinal());
        data.writeInt(this.health);
    }

    public void readSpawnData(ByteBuf data) {
        this.setPositions(BlockPos.func_177969_a((long)data.readLong()), BlockPos.func_177969_a((long)data.readLong()));
        this.gateType = Gate.getGateByID(data.readInt());
        this.edgePosition = data.readFloat();
        this.edgeMax = data.readFloat();
        this.gateStatus = data.readByte();
        this.gateOrientation = EnumFacing.field_82609_l[data.readByte()];
        this.health = data.readInt();
        this.gateType.updateRenderBoundingBox(this);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(HEALTH_TAG)) {
            this.health = tag.func_74762_e(HEALTH_TAG);
            this.hurtAnimationTicks = 20;
        }
    }

    public Owner getOwner() {
        return this.owner;
    }

    public AxisAlignedBB func_184177_bl() {
        return this.renderBoundingBox;
    }

    public void setRenderBoundingBox(AxisAlignedBB renderBoundingBox) {
        this.renderBoundingBox = renderBoundingBox;
    }

    public Optional<BlockPos> getRenderedTilePos() {
        return Optional.ofNullable(this.renderedTilePos);
    }

    public void setRenderedTilePos(BlockPos pos) {
        this.renderedTilePos = pos;
    }
}

