/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.datafixes;

import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.IFixableData;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.structure.block.BlockWoodenCoffin;
import net.shadowmage.ancientwarfare.structure.init.AWStructureBlocks;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.FixResult;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.TileRuleDataFixer;

public class WoodenCoffinFixer
extends TileRuleDataFixer
implements IFixableData {
    private static final String OLD_COFFIN_REG_NAME = "ancientwarfarestructure:coffin";
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 11);

    public WoodenCoffinFixer() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void missingMappingBlock(RegistryEvent.MissingMappings<Block> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.func_110624_b().equals("ancientwarfarestructure") || !entry.key.func_110623_a().equals("coffin")) continue;
            entry.remap((IForgeRegistryEntry)AWStructureBlocks.WOODEN_COFFIN);
        }
    }

    @SubscribeEvent
    public void missingMappingItem(RegistryEvent.MissingMappings<Item> event) {
        for (RegistryEvent.MissingMappings.Mapping entry : event.getAllMappings()) {
            if (!entry.key.func_110624_b().equals("ancientwarfarestructure") || !entry.key.func_110623_a().equals("coffin")) continue;
            entry.ignore();
        }
    }

    public int func_188216_a() {
        return 11;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String oldId = compound.func_74779_i("id");
        if (oldId.equals(OLD_COFFIN_REG_NAME)) {
            compound.func_74778_a("id", "ancientwarfarestructure:wooden_coffin");
            compound.func_74778_a("variant", this.mapToNewVariant(compound.func_74762_e("variant")));
        }
        return compound;
    }

    @Override
    public NBTTagCompound fixRuleCompoundTag(NBTTagCompound compound) {
        return this.func_188217_a(compound);
    }

    @Override
    protected String getFixerName() {
        return "WoodenCoffinFixer";
    }

    @Override
    protected FixResult<String> fixJSONData(String data, NBTTagCompound tag) {
        NBTTagCompound blockStateTag;
        if (tag.func_74764_b("blockState") && (blockStateTag = tag.func_74775_l("blockState")).func_74779_i("blockName").equals(OLD_COFFIN_REG_NAME)) {
            blockStateTag.func_74778_a("blockName", AWStructureBlocks.WOODEN_COFFIN.getRegistryName().toString());
        }
        return super.fixJSONData(data, tag);
    }

    private String mapToNewVariant(int variant) {
        switch (variant) {
            case 2: {
                return BlockWoodenCoffin.Variant.BIRCH.func_176610_l();
            }
            case 3: {
                return BlockWoodenCoffin.Variant.SPRUCE.func_176610_l();
            }
            case 4: {
                return BlockWoodenCoffin.Variant.JUNGLE.func_176610_l();
            }
            case 5: {
                return BlockWoodenCoffin.Variant.ACACIA.func_176610_l();
            }
            case 6: {
                return BlockWoodenCoffin.Variant.DARK_OAK.func_176610_l();
            }
        }
        return BlockWoodenCoffin.Variant.OAK.func_176610_l();
    }

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return ruleName.equals("coffin");
    }
}

