/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.datafixes;

import com.google.common.collect.ImmutableSet;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.potion.Potion;
import net.minecraft.util.datafix.IFixableData;
import net.shadowmage.ancientwarfare.structure.template.StructureTemplate;
import net.shadowmage.ancientwarfare.structure.template.datafixes.fixers.TileRuleDataFixer;

public class LootSettingsPotionRegistryNameFixer
extends TileRuleDataFixer
implements IFixableData {
    private static final ImmutableSet LOOT_TILES = ImmutableSet.of((Object)"ancientwarfarestructure:loot_basket", (Object)"ancientwarfarestructure:advanced_loot_chest_tile", (Object)"ancientwarfarestructure:coffin", (Object)"ancientwarfarestructure:urn_tile");
    private static final StructureTemplate.Version VERSION = new StructureTemplate.Version(2, 10);

    public int func_188216_a() {
        return 10;
    }

    public NBTTagCompound func_188217_a(NBTTagCompound compound) {
        String id = compound.func_74779_i("id");
        if (LOOT_TILES.contains((Object)id)) {
            NBTTagCompound lootNbt = compound.func_74775_l("lootSettings");
            NBTTagList effectList = lootNbt.func_150295_c("effects", 10);
            for (int i = 0; i < effectList.func_74745_c(); ++i) {
                NBTTagCompound effectNbt = effectList.func_150305_b(i);
                int effectId = effectNbt.func_74771_c("Id") & 0xFF;
                Potion potion = Potion.func_188412_a((int)effectId);
                effectNbt.func_74778_a("RegistryName", potion.getRegistryName().toString());
                effectNbt.func_82580_o("Id");
            }
        }
        return compound;
    }

    @Override
    public NBTTagCompound fixRuleCompoundTag(NBTTagCompound compound) {
        return this.func_188217_a(compound);
    }

    @Override
    public StructureTemplate.Version getVersion() {
        return VERSION;
    }

    @Override
    public boolean isForRule(String ruleName) {
        return ruleName.equals("blockTile") || ruleName.equals("inventory") || ruleName.equals("coffin");
    }

    @Override
    protected String getFixerName() {
        return "LootSettingsPotionRegistryNameFixer";
    }
}

