/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketGui;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.container.ContainerSpawnerAdvancedInventoryBase;
import net.shadowmage.ancientwarfare.structure.tile.SpawnerSettings;
import net.shadowmage.ancientwarfare.structure.tile.TileAdvancedSpawner;

public class ContainerSpawnerAdvancedInventoryBlock
extends ContainerSpawnerAdvancedInventoryBase {
    private static final String SPAWNER_SETTINGS_TAG = "spawnerSettings";
    private TileAdvancedSpawner spawner;

    public ContainerSpawnerAdvancedInventoryBlock(EntityPlayer player, int x, int y, int z) {
        super(player, x, y, z);
        Optional<TileAdvancedSpawner> te = WorldTools.getTile((IBlockAccess)player.field_70170_p, new BlockPos(x, y, z), TileAdvancedSpawner.class);
        if (!player.field_70170_p.field_72995_K && te.isPresent()) {
            this.spawner = te.get();
            this.settings = this.spawner.getSettings();
        } else {
            this.settings = SpawnerSettings.getDefaultSettings();
        }
        this.inventory = this.settings.getInventory();
        this.addSettingsInventorySlots();
        this.addPlayerSlots(8, 70, 8);
    }

    @Override
    public boolean func_75145_c(EntityPlayer var1) {
        return this.spawner.func_145835_a(var1.field_70165_t, var1.field_70163_u, var1.field_70161_v) <= 64.0;
    }

    @Override
    public void sendInitData() {
        if (!this.player.field_70170_p.field_72995_K) {
            this.sendSettingsToClient();
        }
    }

    private void sendSettingsToClient() {
        NBTTagCompound tag = new NBTTagCompound();
        this.settings.writeToNBT(tag);
        PacketGui pkt = new PacketGui();
        pkt.setTag(SPAWNER_SETTINGS_TAG, tag);
        NetworkHandler.sendToPlayer((EntityPlayerMP)this.player, pkt);
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(SPAWNER_SETTINGS_TAG)) {
            if (this.player.field_70170_p.field_72995_K) {
                this.settings.readFromNBT(tag.func_74775_l(SPAWNER_SETTINGS_TAG));
                this.refreshGui();
            } else {
                this.spawner.func_145839_a(tag);
                BlockTools.notifyBlockUpdate(this.spawner);
            }
        }
    }
}

