/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.container;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootTableList;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.util.EntityTools;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.structure.config.AWStructureStatics;
import net.shadowmage.ancientwarfare.structure.item.ItemLootChestPlacer;
import net.shadowmage.ancientwarfare.structure.tile.LootSettings;

public class ContainerLootChestPlacer
extends ContainerBase {
    private static final String LOOT_CONTAINER_NAME_TAG = "lootContainerName";
    private final ItemStack placer;

    public ContainerLootChestPlacer(EntityPlayer player, int x, int y, int z) {
        super(player);
        this.placer = EntityTools.getItemFromEitherHand(player, ItemLootChestPlacer.class);
    }

    public List<String> getLootTableNames() {
        return LootTableList.func_186374_a().stream().map(ResourceLocation::toString).filter(rl -> !AWStructureStatics.lootTableExclusions.contains(rl)).collect(Collectors.toList());
    }

    @Override
    public void handlePacketData(NBTTagCompound tag) {
        if (tag.func_74764_b(LOOT_CONTAINER_NAME_TAG)) {
            this.setContainer(tag.func_74779_i(LOOT_CONTAINER_NAME_TAG));
            return;
        }
        this.setLootSettings(LootSettings.deserializeNBT(tag));
    }

    public void setLootSettings(LootSettings lootSettings) {
        if (this.player.field_70170_p.field_72995_K) {
            this.sendDataToServer(lootSettings.serializeNBT());
        }
        ItemLootChestPlacer.setLootSettings(this.placer, lootSettings);
    }

    public Optional<LootSettings> getLootSettings() {
        return ItemLootChestPlacer.getLootSettings(this.placer);
    }

    public ItemLootChestPlacer.LootContainerInfo getLootContainerInfo() {
        return ItemLootChestPlacer.getLootContainerInfo(this.placer);
    }

    public void setContainer(String blockName) {
        if (this.player.field_70170_p.field_72995_K) {
            this.sendDataToServer(new NBTBuilder().setString(LOOT_CONTAINER_NAME_TAG, blockName).build());
        }
        ItemLootChestPlacer.setContainerName(this.placer, blockName);
    }
}

