/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block.altar;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.structure.block.altar.BlockAltarTop;
import net.shadowmage.ancientwarfare.structure.render.ParticleSun;

public class BlockAltarSun
extends BlockAltarTop {
    private static final AxisAlignedBB AABB_NORTH_SOUTH = new AxisAlignedBB(0.0625, 0.0, 0.3125, 0.9375, 1.0, 0.6875);
    private static final AxisAlignedBB AABB_WEST_EAST = new AxisAlignedBB(0.3125, 0.0, 0.0625, 0.6875, 1.0, 0.9375);

    public BlockAltarSun() {
        super(Material.field_151575_d, "altar_sun");
        this.func_149715_a(0.8f);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)) {
            case WEST: 
            case EAST: {
                return AABB_WEST_EAST;
            }
        }
        return AABB_NORTH_SOUTH;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(IBlockState state, BlockRenderLayer layer) {
        return layer == BlockRenderLayer.CUTOUT;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState state, World world, BlockPos pos, Random rand) {
        int maxParticles = world.field_73012_v.nextInt(3);
        for (int i = 0; i < maxParticles; ++i) {
            double angle = (double)world.field_73012_v.nextFloat() * Math.PI * 2.0;
            float distance = world.field_73012_v.nextFloat() * 5.0f / 16.0f;
            double sunHorizontalOffset = 0.5 + Math.sin(angle) * (double)distance;
            double distanceFromSun = 0.5 + (world.field_73012_v.nextBoolean() ? 0.1 : -0.1);
            double yOffset = 0.55 + Math.cos(angle) * (double)distance;
            EnumFacing.Axis facingAxis = ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176740_k();
            double xOffset = facingAxis == EnumFacing.Axis.X ? distanceFromSun : sunHorizontalOffset;
            double zOffset = facingAxis == EnumFacing.Axis.Z ? distanceFromSun : sunHorizontalOffset;
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSun(world, (double)pos.func_177958_n() + xOffset, (double)pos.func_177956_o() + yOffset, (double)pos.func_177952_p() + zOffset));
        }
    }
}

