/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;

public class BlockTotemCube
extends BlockBaseStructure {
    private boolean isLit;

    public BlockTotemCube(String regName, boolean isLit) {
        super(Material.field_151576_e, regName);
        this.isLit = isLit;
        if (isLit) {
            this.func_149715_a(0.875f);
        }
    }

    public BlockTotemCube(String regName) {
        this(regName, false);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{CoreProperties.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.field_176754_o[meta]);
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b();
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d());
    }

    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (this.isLit) {
            double d0 = (double)pos.func_177958_n() + 0.5;
            double d1 = (double)pos.func_177956_o() + rand.nextDouble() * 6.0 / 16.0 + 0.3125;
            double d2 = (double)pos.func_177952_p() + 0.5;
            double d4 = rand.nextDouble() * 0.6 - 0.3;
            if (rand.nextDouble() < 0.1) {
                worldIn.func_184134_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5, SoundEvents.field_187652_bv, SoundCategory.BLOCKS, 1.0f, 1.0f, false);
            }
            EnumFacing enumfacing = (EnumFacing)stateIn.func_177229_b((IProperty)CoreProperties.FACING);
            this.spawnParticles(worldIn, d0, d1, d2, d4, enumfacing);
            this.spawnParticles(worldIn, d0, d1, d2, d4, enumfacing.func_176734_d());
        }
    }

    private void spawnParticles(World worldIn, double x, double y, double z, double d4, EnumFacing enumfacing) {
        switch (enumfacing) {
            case WEST: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x - 0.52, y, z + d4, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x - 0.52, y, z + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case EAST: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + 0.52, y, z + d4, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + 0.52, y, z + d4, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            case NORTH: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + d4, y, z - 0.52, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + d4, y, z - 0.52, 0.0, 0.0, 0.0, new int[0]);
                break;
            }
            default: {
                worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, x + d4, y, z + 0.52, 0.0, 0.0, 0.0, new int[0]);
                worldIn.func_175688_a(EnumParticleTypes.FLAME, x + d4, y, z + 0.52, 0.0, 0.0, 0.0, new int[0]);
            }
        }
    }
}

