/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.RayTraceUtils;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.block.WoodVariant;
import net.shadowmage.ancientwarfare.structure.util.BlockStateProperties;
import net.shadowmage.ancientwarfare.structure.util.WoodVariantHelper;

public class BlockTable
extends BlockBaseStructure {
    private static final PropertyBool LEG_NORTHEAST = PropertyBool.func_177716_a((String)"leg_northeast");
    private static final PropertyBool LEG_SOUTHEAST = PropertyBool.func_177716_a((String)"leg_southeast");
    private static final PropertyBool LEG_SOUTHWEST = PropertyBool.func_177716_a((String)"leg_southwest");
    private static final PropertyBool LEG_NORTHWEST = PropertyBool.func_177716_a((String)"leg_northwest");
    private static final AxisAlignedBB TOP_AABB = new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0);
    private static final AxisAlignedBB LEG_NORTHWEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 0.125, 0.875, 0.125);
    private static final AxisAlignedBB LEG_NORTHEAST_AABB = new AxisAlignedBB(0.875, 0.0, 0.0, 1.0, 0.875, 0.125);
    private static final AxisAlignedBB LEG_SOUTHEAST_AABB = new AxisAlignedBB(0.875, 0.0, 0.875, 1.0, 0.875, 1.0);
    private static final AxisAlignedBB LEG_SOUTHWEST_AABB = new AxisAlignedBB(0.0, 0.0, 0.875, 0.125, 0.875, 1.0);

    public BlockTable() {
        super(Material.field_151575_d, "table");
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        WoodVariantHelper.getSubBlocks(this, items);
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariantHelper.getVariant(stack))));
    }

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return WoodVariantHelper.getPickBlock(this, state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{BlockStateProperties.VARIANT, LEG_NORTHEAST, LEG_NORTHWEST, LEG_SOUTHEAST, LEG_SOUTHWEST});
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        LegPositions legPositions = this.getLegPositions(world, pos);
        state = state.func_177226_a((IProperty)LEG_NORTHEAST, (Comparable)Boolean.valueOf(legPositions.northEast));
        state = state.func_177226_a((IProperty)LEG_SOUTHEAST, (Comparable)Boolean.valueOf(legPositions.southEast));
        state = state.func_177226_a((IProperty)LEG_SOUTHWEST, (Comparable)Boolean.valueOf(legPositions.southWest));
        state = state.func_177226_a((IProperty)LEG_NORTHWEST, (Comparable)Boolean.valueOf(legPositions.northWest));
        return state;
    }

    private LegPositions getLegPositions(IBlockAccess world, BlockPos pos) {
        boolean north = world.func_180495_p(pos.func_177978_c()).func_177230_c() == this;
        boolean east = world.func_180495_p(pos.func_177974_f()).func_177230_c() == this;
        boolean south = world.func_180495_p(pos.func_177968_d()).func_177230_c() == this;
        boolean west = world.func_180495_p(pos.func_177976_e()).func_177230_c() == this;
        return new LegPositions(!north && !east, !south && !east, !south && !west, !north && !west);
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(BlockStateProperties.VARIANT, (Comparable)((Object)WoodVariant.byMeta(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((WoodVariant)((Object)state.func_177229_b(BlockStateProperties.VARIANT))).getMeta();
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return face == EnumFacing.UP ? BlockFaceShape.SOLID : BlockFaceShape.UNDEFINED;
    }

    @Nullable
    public RayTraceResult func_180636_a(IBlockState blockState, World world, BlockPos pos, Vec3d start, Vec3d end) {
        return RayTraceUtils.raytraceMultiAABB(this.getAABBs(world, pos), pos, start, end, (rtr, aabb) -> rtr);
    }

    private List<AxisAlignedBB> getAABBs(World world, BlockPos pos) {
        LegPositions legPositions = this.getLegPositions((IBlockAccess)world, pos);
        ArrayList<AxisAlignedBB> aabbs = new ArrayList<AxisAlignedBB>();
        aabbs.add(TOP_AABB);
        if (legPositions.northEast) {
            aabbs.add(LEG_NORTHEAST_AABB);
        }
        if (legPositions.northWest) {
            aabbs.add(LEG_NORTHWEST_AABB);
        }
        if (legPositions.southEast) {
            aabbs.add(LEG_SOUTHEAST_AABB);
        }
        if (legPositions.southWest) {
            aabbs.add(LEG_SOUTHWEST_AABB);
        }
        return aabbs;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        return RayTraceUtils.getSelectedBoundingBox(this.getAABBs(world, pos), pos, (EntityPlayer)player);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        WoodVariantHelper.registerClient(this, propString -> "leg_northeast=true,leg_northwest=true,leg_southeast=true,leg_southwest=true," + propString);
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        WoodVariantHelper.getDrops(this, drops, state);
    }

    private static class LegPositions {
        private final boolean northEast;
        private final boolean southEast;
        private final boolean southWest;
        private final boolean northWest;

        private LegPositions(boolean northEast, boolean southEast, boolean southWest, boolean northWest) {
            this.northEast = northEast;
            this.southEast = southEast;
            this.southWest = southWest;
            this.northWest = northWest;
        }
    }
}

