/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.entity.EntitySeat;
import net.shadowmage.ancientwarfare.structure.util.RotationLimit;

public abstract class BlockSeat
extends BlockBaseStructure {
    private static final Vec3d DEFAULT_SEAT_OFFSET = new Vec3d(0.5, 0.5, 0.5);

    public BlockSeat(Material material, String regName) {
        super(material, regName);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && !this.isOccupied(world, pos)) {
            EntitySeat seatEntity = new EntitySeat(world, new Vec3d((Vec3i)pos).func_178787_e(this.getSeatOffset()), pos);
            world.func_72838_d((Entity)seatEntity);
            playerIn.func_184220_m((Entity)seatEntity);
        }
        return true;
    }

    protected Vec3d getSeatOffset() {
        return DEFAULT_SEAT_OFFSET;
    }

    private boolean isOccupied(World world, BlockPos pos) {
        List seats = world.func_72872_a(EntitySeat.class, new AxisAlignedBB(pos, pos.func_177982_a(1, 1, 1)).func_186662_g(1.0));
        for (EntitySeat seat : seats) {
            if (!seat.getSeatPos().equals((Object)pos)) continue;
            return seat.func_184207_aI();
        }
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public abstract RotationLimit getRotationLimit(World var1, BlockPos var2, IBlockState var3);
}

