/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockFlag;
import net.shadowmage.ancientwarfare.structure.render.ParticleOnlyModel;
import net.shadowmage.ancientwarfare.structure.render.ParticleSun;
import net.shadowmage.ancientwarfare.structure.render.ProtectionFlagRenderer;
import net.shadowmage.ancientwarfare.structure.tile.TileProtectionFlag;

public class BlockProtectionFlag
extends BlockFlag {
    public BlockProtectionFlag() {
        super(Material.field_151575_d, "protection_flag");
        this.func_149752_b(6000000.0f);
        this.func_149715_a(0.8666667f);
    }

    public float func_180647_a(IBlockState state, EntityPlayer player, World worldIn, BlockPos pos) {
        float original = super.func_180647_a(state, player, worldIn, pos);
        return WorldTools.getTile((IBlockAccess)worldIn, pos, TileProtectionFlag.class).map(te -> Float.valueOf(te.getPlayerRelativeBlockHardness(player, original))).orElse(Float.valueOf(original)).floatValue();
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileProtectionFlag();
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        WorldTools.getTile((IBlockAccess)world, pos, TileProtectionFlag.class).ifPresent(te -> te.onActivatedBy(player));
        return true;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ModelResourceLocation modelLocation = new ModelResourceLocation(this.getRegistryName(), "normal");
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new ProtectionFlagRenderer());
        ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)ParticleOnlyModel.INSTANCE);
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return modelLocation;
            }
        });
        ClientRegistry.bindTileEntitySpecialRenderer(TileProtectionFlag.class, (TileEntitySpecialRenderer)new ProtectionFlagRenderer());
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int maxParticles = worldIn.field_73012_v.nextInt(10);
        for (int i = 0; i < maxParticles; ++i) {
            double d0 = (double)pos.func_177958_n() + (double)worldIn.field_73012_v.nextFloat();
            double d1 = (double)pos.func_177956_o() + 1.9 * (double)worldIn.field_73012_v.nextFloat();
            double d2 = (double)pos.func_177952_p() + (double)worldIn.field_73012_v.nextFloat();
            worldIn.func_175688_a(EnumParticleTypes.SMOKE_NORMAL, d0, d1, d2, 0.0, 0.0, 0.0, new int[0]);
            Minecraft.func_71410_x().field_71452_i.func_78873_a((Particle)new ParticleSun(worldIn, d0, d1, d2));
        }
    }
}

