/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.render.property.CoreProperties;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.item.ItemBlockGravestone;
import net.shadowmage.ancientwarfare.structure.render.RenderLootInfo;
import net.shadowmage.ancientwarfare.structure.tile.TileGravestone;

public class BlockGravestone
extends BlockBaseStructure {
    private static final AxisAlignedBB AABB_NORTH = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.1875, 0.625);
    private static final AxisAlignedBB AABB_SOUTH = new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.1875, 0.625);
    private static final AxisAlignedBB AABB_WEST = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.1875, 1.0);
    private static final AxisAlignedBB AABB_EAST = new AxisAlignedBB(0.375, 0.0, 0.0, 0.625, 1.1875, 1.0);
    private static final PropertyInteger VARIANT = PropertyInteger.func_177719_a((String)"variant", (int)1, (int)8);

    public BlockGravestone() {
        super(Material.field_151576_e, "gravestone");
        this.func_149711_c(4.0f);
        this.func_149672_a(SoundType.field_185851_d);
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess world, BlockPos pos) {
        return state.func_177226_a((IProperty)VARIANT, (Comparable)WorldTools.getTile(world, pos, TileGravestone.class).map(TileGravestone::getVariant).orElse(1));
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int variant = 1; variant <= 8; ++variant) {
            items.add((Object)ItemBlockGravestone.getVariantStack(variant));
        }
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{VARIANT, CoreProperties.FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)).func_176736_b();
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileGravestone();
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        world.func_175656_a(pos, state.func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(ItemBlockGravestone.getVariant(stack))));
        WorldTools.getTile((IBlockAccess)world, pos, TileGravestone.class).ifPresent(te -> te.setPrimaryFacing(placer.func_174811_aO().func_176734_d()));
        WorldTools.getTile((IBlockAccess)world, pos, TileGravestone.class).ifPresent(te -> te.setVariant(ItemBlockGravestone.getVariant(stack)));
        super.func_180633_a(world, pos, state, placer, stack);
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        WorldTools.getTile((IBlockAccess)world, pos, TileGravestone.class).ifPresent(te -> InventoryTools.dropItemInWorld(world, ItemBlockGravestone.getVariantStack(te.getVariant()), pos));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        WorldTools.getTile((IBlockAccess)world, pos, TileGravestone.class).ifPresent(te -> te.activate(player));
        return true;
    }

    public IBlockState func_180642_a(World worldIn, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        return this.func_176223_P().func_177226_a((IProperty)CoreProperties.FACING, (Comparable)placer.func_174811_aO().func_176734_d()).func_177226_a((IProperty)VARIANT, (Comparable)Integer.valueOf(ItemBlockGravestone.getVariant(placer.func_184607_cu())));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        switch ((EnumFacing)state.func_177229_b((IProperty)CoreProperties.FACING)) {
            case NORTH: {
                return AABB_NORTH;
            }
            case SOUTH: {
                return AABB_SOUTH;
            }
            case WEST: {
                return AABB_WEST;
            }
            case EAST: {
                return AABB_EAST;
            }
        }
        return new AxisAlignedBB(0.0, 0.0, 0.375, 1.0, 1.1875, 0.625);
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation baseLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(baseLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        String modelPropString = "facing=west,variant=%d";
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> {
            if (!stack.func_77942_o()) {
                return new ModelResourceLocation(baseLocation, String.format(modelPropString, 8));
            }
            return new ModelResourceLocation(baseLocation, String.format(modelPropString, ItemBlockGravestone.getVariant(stack)));
        });
        for (int variant = 1; variant < 9; ++variant) {
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(baseLocation, String.format(modelPropString, variant))});
        }
        ClientRegistry.bindTileEntitySpecialRenderer(TileGravestone.class, new RenderLootInfo());
    }

    public void spawnPotionParticle() {
    }
}

