/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyHelper;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMapperBase;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.NBTBuilder;
import net.shadowmage.ancientwarfare.npc.item.ItemCoin;
import net.shadowmage.ancientwarfare.structure.block.BlockBaseStructure;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSoundTypes;
import net.shadowmage.ancientwarfare.structure.init.AWStructureSounds;

public class BlockCoinStack
extends BlockBaseStructure {
    private ItemCoin.CoinMetal coinMetal;
    private static final Map<Integer, AxisAlignedBB> STACK_SIZE_AABBs = new ImmutableMap.Builder().put((Object)8, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1, 1.0)).put((Object)16, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.25, 1.0)).put((Object)24, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.37, 1.0)).put((Object)32, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.57, 1.0)).put((Object)40, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.81, 1.0)).put((Object)48, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.81, 1.0)).put((Object)56, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.95, 1.0)).put((Object)64, (Object)new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)).build();
    private static final String STACK_SIZE_TAG = "size";
    private static final PropertyStackSize STACK_SIZE = new PropertyStackSize();

    public BlockCoinStack(String regName, ItemCoin.CoinMetal coinMetal) {
        super(Material.field_151578_c, regName);
        this.func_149711_c(0.3f);
        this.func_149752_b(0.4f);
        this.coinMetal = coinMetal;
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{STACK_SIZE});
    }

    public void func_149666_a(CreativeTabs itemIn, NonNullList<ItemStack> items) {
        for (int stackSize = 8; stackSize < 65; stackSize += 8) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            stack.func_77982_d(new NBTBuilder().setInteger(STACK_SIZE_TAG, stackSize).build());
            items.add((Object)stack);
        }
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)STACK_SIZE, (Comparable)Integer.valueOf((meta + 1) * 8));
    }

    public int func_176201_c(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)STACK_SIZE) / 8 - 1;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!stack.func_77942_o()) {
            return;
        }
        worldIn.func_175656_a(pos, state.func_177226_a((IProperty)STACK_SIZE, (Comparable)Integer.valueOf(this.getCoinStackSize(stack))));
    }

    private int getCoinStackSize(ItemStack stack) {
        return stack.func_77942_o() ? stack.func_77978_p().func_74762_e(STACK_SIZE_TAG) : 0;
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        drops.add((Object)ItemCoin.getCoinStack(this.coinMetal, (Integer)state.func_177229_b((IProperty)STACK_SIZE)));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.field_72995_K) {
            return true;
        }
        if (ItemCoin.isSpecificCoin(stack, this.coinMetal)) {
            this.addToStack(world, pos, state, player, stack);
        } else {
            this.removeFromStack(world, pos, state, player);
        }
        return true;
    }

    private void removeFromStack(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        int blockstacksize = (Integer)state.func_177229_b((IProperty)STACK_SIZE);
        InventoryTools.insertOrDropItem((IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null), ItemCoin.getCoinStack(this.coinMetal, 8), world, pos);
        if (blockstacksize > 8) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)STACK_SIZE, (Comparable)Integer.valueOf(blockstacksize - 8)));
        } else {
            world.func_175698_g(pos);
        }
        world.func_184133_a(null, pos, AWStructureSounds.COIN_STACK_INTERACT, SoundCategory.PLAYERS, 0.5f, 1.0f);
    }

    private void addToStack(World world, BlockPos pos, IBlockState state, EntityPlayer player, ItemStack stack) {
        int blockStackSize;
        if (stack.func_190916_E() >= 8 && (blockStackSize = ((Integer)state.func_177229_b((IProperty)STACK_SIZE)).intValue()) < 64) {
            world.func_175656_a(pos, state.func_177226_a((IProperty)STACK_SIZE, (Comparable)Integer.valueOf(blockStackSize + 8)));
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(8);
            }
        }
        world.func_184133_a(null, pos, AWStructureSounds.COIN_STACK_INTERACT, SoundCategory.PLAYERS, 0.5f, 1.0f);
    }

    public SoundType getSoundType(IBlockState state, World world, BlockPos pos, @Nullable Entity entity) {
        return AWStructureSoundTypes.COINSTACK;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        tooltip.add(this.getCoinStackSize(stack) + " " + I18n.func_135052_a((String)"guistrings.structure.coins", (Object[])new Object[0]));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return STACK_SIZE_AABBs.get(state.func_177229_b((IProperty)STACK_SIZE));
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerClient() {
        final ResourceLocation baseLocation = new ResourceLocation("ancientwarfare", "structure/" + this.getRegistryName().func_110623_a());
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)new StateMapperBase(){

            @SideOnly(value=Side.CLIENT)
            protected ModelResourceLocation func_178132_a(IBlockState state) {
                return new ModelResourceLocation(baseLocation, this.func_178131_a((Map)state.func_177228_b()));
            }
        });
        String modelPropInteger = "size=%s";
        ModelLoader.setCustomMeshDefinition((Item)Item.func_150898_a((Block)this), stack -> {
            if (!stack.func_77942_o()) {
                return new ModelResourceLocation(baseLocation, String.format(modelPropInteger, 8));
            }
            return new ModelResourceLocation(baseLocation, String.format(modelPropInteger, stack.func_77978_p().func_74762_e(STACK_SIZE_TAG)));
        });
        for (int stackSize = 8; stackSize < 65; stackSize += 8) {
            ModelLoader.registerItemVariants((Item)Item.func_150898_a((Block)this), (ResourceLocation[])new ResourceLocation[]{new ModelResourceLocation(baseLocation, String.format(modelPropInteger, stackSize))});
        }
    }

    public static class PropertyStackSize
    extends PropertyHelper<Integer> {
        private final ImmutableSet<Integer> allowedValues = ImmutableSet.of((Object)8, (Object)16, (Object)24, (Object)32, (Object)40, (Object)48, (Object[])new Integer[]{56, 64});

        private PropertyStackSize() {
            super(BlockCoinStack.STACK_SIZE_TAG, Integer.class);
        }

        public Collection<Integer> func_177700_c() {
            return this.allowedValues;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof PropertyStackSize && super.equals(other)) {
                PropertyStackSize propertyinteger = (PropertyStackSize)((Object)other);
                return this.allowedValues.equals(propertyinteger.allowedValues);
            }
            return false;
        }

        public int hashCode() {
            return 31 * super.hashCode() + this.allowedValues.hashCode();
        }

        public Optional<Integer> func_185929_b(String value) {
            try {
                Integer integer = Integer.valueOf(value);
                return this.allowedValues.contains((Object)integer) ? Optional.of((Object)integer) : Optional.absent();
            }
            catch (NumberFormatException var3) {
                return Optional.absent();
            }
        }

        public String getName(Integer value) {
            return value.toString();
        }
    }
}

