/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.structure.block;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.structure.block.BlockMulti;
import net.shadowmage.ancientwarfare.structure.tile.TileCoffin;

public abstract class BlockCoffin<T extends TileCoffin>
extends BlockMulti<T> {
    public BlockCoffin(Material material, String regName, Supplier<T> instantiateTe, Class<T> teClass) {
        super(material, regName, instantiateTe, teClass);
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return Boolean.TRUE.equals(state.func_177229_b((IProperty)INVISIBLE)) ? EnumBlockRenderType.INVISIBLE : EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149721_r(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState baseState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_176225_a(IBlockState blockState, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return false;
    }

    public void func_176208_a(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        WorldTools.getTile((IBlockAccess)world, pos, TileCoffin.class).ifPresent(te -> InventoryTools.dropItemInWorld(world, this.getVariantStack(te.getVariant()), pos));
    }

    protected abstract ItemStack getVariantStack(IVariant var1);

    protected abstract IVariant getDefaultVariant();

    public ItemStack getPickBlock(IBlockState state, RayTraceResult target, World world, BlockPos pos, EntityPlayer player) {
        return this.getVariantStack(WorldTools.getTile((IBlockAccess)world, pos, TileCoffin.class).map(TileCoffin::getVariant).orElse(this.getDefaultVariant()));
    }

    public void getDrops(NonNullList<ItemStack> drops, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        WorldTools.getTile((IBlockAccess)world, pos, TileCoffin.class).ifPresent(TileCoffin::open);
        return true;
    }

    public static interface IVariant
    extends IStringSerializable {
    }

    public static enum CoffinDirection implements IStringSerializable
    {
        NORTH(0, "north", EnumFacing.NORTH),
        EAST(90, "east", EnumFacing.EAST),
        SOUTH(180, "south", EnumFacing.SOUTH),
        WEST(270, "west", EnumFacing.WEST),
        NORTH_EAST(45, "north_east", EnumFacing.NORTH),
        SOUTH_EAST(135, "south_east", EnumFacing.NORTH),
        SOUTH_WEST(225, "south_west", EnumFacing.NORTH),
        NORTH_WEST(315, "north_west", EnumFacing.NORTH);

        private int rotationAngle;
        private String name;
        private EnumFacing facing;
        private static final Map<String, CoffinDirection> NAME_VALUES;
        private static final Map<Integer, CoffinDirection> ROTATION_VALUES;

        private CoffinDirection(int rotationAngle, String name, EnumFacing facing) {
            this.rotationAngle = rotationAngle;
            this.name = name;
            this.facing = facing;
        }

        public static CoffinDirection fromYaw(float rotationYaw) {
            return CoffinDirection.fromRotation((int)Trig.wrapTo360(rotationYaw + 180.0f + 23.0f) / 45 * 45);
        }

        public int getRotationAngle() {
            return this.rotationAngle;
        }

        public static CoffinDirection fromFacing(EnumFacing facing) {
            switch (facing) {
                case SOUTH: {
                    return SOUTH;
                }
                case EAST: {
                    return EAST;
                }
                case WEST: {
                    return WEST;
                }
            }
            return NORTH;
        }

        public CoffinDirection rotateY() {
            switch (this) {
                case EAST: {
                    return SOUTH;
                }
                case SOUTH: {
                    return WEST;
                }
                case WEST: {
                    return NORTH;
                }
                case NORTH_EAST: {
                    return SOUTH_EAST;
                }
                case SOUTH_EAST: {
                    return SOUTH_WEST;
                }
                case SOUTH_WEST: {
                    return NORTH_WEST;
                }
                case NORTH_WEST: {
                    return NORTH_EAST;
                }
            }
            return EAST;
        }

        public EnumFacing getFacing() {
            return this.facing;
        }

        public String func_176610_l() {
            return this.name;
        }

        public static CoffinDirection fromName(String name) {
            return NAME_VALUES.getOrDefault(name, NORTH);
        }

        static CoffinDirection fromRotation(int rotationAngle) {
            return ROTATION_VALUES.getOrDefault(rotationAngle, NORTH);
        }

        static {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            ImmutableMap.Builder builderRotation = ImmutableMap.builder();
            for (CoffinDirection coffinDirection : CoffinDirection.values()) {
                builder.put((Object)coffinDirection.func_176610_l(), (Object)coffinDirection);
                builderRotation.put((Object)coffinDirection.getRotationAngle(), (Object)coffinDirection);
            }
            NAME_VALUES = builder.build();
            ROTATION_VALUES = builderRotation.build();
        }
    }
}

