/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.InventoryTools;
import net.shadowmage.ancientwarfare.npc.trade.POTradeTransferEntry;

public final class POTradeWithdrawEntry
extends POTradeTransferEntry {
    @Override
    protected POTradeTransferEntry.TransferType getDefaultType() {
        return POTradeWithdrawType.ALL_OF;
    }

    @Override
    public void toggleType() {
        int o = this.getType().ordinal();
        if (++o >= POTradeWithdrawType.values().length) {
            o = 0;
        }
        this.setType(this.getTypeFrom(o));
    }

    @Override
    protected POTradeTransferEntry.TransferType getTypeFrom(int type) {
        return POTradeWithdrawType.values()[type];
    }

    public static enum POTradeWithdrawType implements POTradeTransferEntry.TransferType
    {
        ALL_OF{

            @Override
            public void doTransfer(IItemHandler storage, IItemHandler move, ItemStack filter) {
                int count = InventoryTools.getCountOf(move, filter);
                if (count > 0) {
                    InventoryTools.transferItems(move, storage, filter, count);
                }
            }
        }
        ,
        FILL_TO{

            @Override
            public void doTransfer(IItemHandler storage, IItemHandler move, ItemStack filter) {
                int count = InventoryTools.getCountOf(storage, filter);
                if (count < filter.func_190916_E()) {
                    InventoryTools.transferItems(move, storage, filter, filter.func_190916_E() - count);
                }
            }
        };

    }
}

