/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.npc.trade.POTradePoint;

public final class POTradeRoute {
    private List<POTradePoint> route = new ArrayList<POTradePoint>();

    public int size() {
        return this.route.size();
    }

    public POTradePoint get(int index) {
        return this.route.get(index);
    }

    public void decrementRoutePoint(int index) {
        if (index <= 0 || index >= this.route.size()) {
            return;
        }
        POTradePoint p = this.route.remove(index);
        this.route.add(index - 1, p);
    }

    public void incrementRoutePoint(int index) {
        if (index < 0 || index >= this.route.size() - 1) {
            return;
        }
        POTradePoint p = this.route.remove(index);
        this.route.add(index + 1, p);
    }

    public void deleteRoutePoint(int index) {
        if (index < 0 || index >= this.route.size()) {
            return;
        }
        this.route.remove(index);
    }

    public void addRoutePoint(BlockPos pos) {
        POTradePoint p = new POTradePoint();
        p.position = pos;
        p.delay = 1200;
        p.shouldUpkeep = false;
        this.route.add(p);
    }

    public void setPointDelay(int index, int delay) {
        this.route.get(index).setDelay(delay);
    }

    public void setUpkeep(int index, boolean val) {
        this.route.get(index).setShouldUpkeep(val);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.route.clear();
        NBTTagList list = tag.func_150295_c("route", 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            POTradePoint p = new POTradePoint();
            p.readFromNBT(list.func_150305_b(i));
            this.route.add(p);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        NBTTagList list = new NBTTagList();
        for (POTradePoint point : this.route) {
            list.func_74742_a((NBTBase)point.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("route", (NBTBase)list);
        return tag;
    }
}

