/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.trade;

import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.npc.trade.Trade;

public class FactionTrade
extends Trade {
    private static final String REFILL_TIME_TAG = "refillTime";
    private int refillFrequency = 6000;
    private long refillTime = -1L;
    private int maxAvailable = 1;
    private int currentAvailable = 1;

    public boolean hasItems() {
        for (int i = 0; i < this.size(); ++i) {
            if (this.getInputStack(i).func_190926_b() && this.getOutputStack(i).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public int getRefillFrequency() {
        return this.refillFrequency;
    }

    public int getMaxAvailable() {
        return this.maxAvailable;
    }

    public int getCurrentAvailable() {
        return this.currentAvailable;
    }

    public void setRefillFrequency(int refill) {
        this.refillFrequency = refill;
    }

    public void setMaxAvailable(int max) {
        this.maxAvailable = max;
        this.currentAvailable = max;
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("refillFrequency", this.refillFrequency);
        tag.func_74772_a(REFILL_TIME_TAG, this.refillTime);
        tag.func_74768_a("maxAvailable", this.maxAvailable);
        tag.func_74768_a("currentAvailable", this.currentAvailable);
        return super.writeToNBT(tag);
    }

    @Override
    public void readFromNBT(NBTTagCompound tag) {
        this.refillFrequency = tag.func_74762_e("refillFrequency");
        this.refillTime = tag.func_74764_b(REFILL_TIME_TAG) ? tag.func_74763_f(REFILL_TIME_TAG) : -1L;
        this.maxAvailable = tag.func_74762_e("maxAvailable");
        this.currentAvailable = tag.func_74762_e("currentAvailable");
        super.readFromNBT(tag);
    }

    public void updateTrade(long totalWorldTime) {
        if (this.refillTime == -1L) {
            this.refillTime = totalWorldTime + (long)this.refillFrequency;
        }
        if (this.refillFrequency > 0 && this.refillTime > 0L && this.refillTime <= totalWorldTime) {
            long timeDiff = totalWorldTime - this.refillTime;
            while (this.currentAvailable < this.maxAvailable && timeDiff >= 0L) {
                timeDiff -= (long)this.refillFrequency;
                ++this.currentAvailable;
            }
            this.refillTime = this.currentAvailable < this.maxAvailable ? totalWorldTime + (long)this.refillFrequency : 0L;
        } else if (this.refillFrequency == 0) {
            this.currentAvailable = this.maxAvailable;
        }
    }

    @Override
    public boolean performTrade(EntityPlayer player, @Nullable IItemHandler storage) {
        return this.currentAvailable > 0 && super.performTrade(player, null);
    }

    @Override
    protected void doTrade(EntityPlayer player, @Nullable IItemHandler storage) {
        if (this.refillFrequency != 0) {
            --this.currentAvailable;
            this.refillTime = player.field_70170_p.func_82737_E() + (long)this.refillFrequency;
        }
        super.doTrade(player, storage);
    }

    public long getRefillTime() {
        return this.refillTime;
    }
}

