/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.shadowmage.ancientwarfare.npc.trade.FactionTrade;

public class FactionTradeTemplate {
    private final List<ItemStack> input;
    private final List<ItemStack> output;
    private final int refillFrequency;
    private final int maxTrades;

    public FactionTradeTemplate(List<ItemStack> input, List<ItemStack> output, int refillFrequency, int maxTrades) {
        this.input = input;
        this.output = output;
        this.refillFrequency = refillFrequency;
        this.maxTrades = maxTrades;
    }

    public List<ItemStack> getInput() {
        return this.input;
    }

    public List<ItemStack> getOutput() {
        return this.output;
    }

    public int getRefillFrequency() {
        return this.refillFrequency;
    }

    public int getMaxTrades() {
        return this.maxTrades;
    }

    public FactionTrade toTrade() {
        FactionTrade trade = new FactionTrade();
        trade.setMaxAvailable(this.maxTrades);
        trade.setRefillFrequency(this.refillFrequency);
        int slot = 0;
        for (ItemStack stack : this.input) {
            trade.setInputStack(slot++, stack);
        }
        slot = 0;
        for (ItemStack stack : this.output) {
            trade.setOutputStack(slot++, stack);
        }
        return trade;
    }

    public static FactionTradeTemplate fromTrade(FactionTrade trade) {
        return new FactionTradeTemplate(trade.getInput(), trade.getOutput(), trade.getRefillFrequency(), trade.getMaxAvailable());
    }
}

