/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.shadowmage.ancientwarfare.core.registry.IRegistryDataParser;
import net.shadowmage.ancientwarfare.core.util.ItemTools;
import net.shadowmage.ancientwarfare.core.util.parsing.JsonHelper;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.registry.FactionTradeListTemplate;
import net.shadowmage.ancientwarfare.npc.registry.FactionTradeTemplate;

public class FactionTradeListRegistry {
    private static final String DEFAULT_REGISTRY_LOCATION = "npc/faction_trade_lists.json";
    private static Map<String, FactionTradeListTemplate> defaultTemplates;
    private static Map<String, Map<String, FactionTradeListTemplate>> factionTemplates;

    private FactionTradeListRegistry() {
    }

    public static Map<String, FactionTradeListTemplate> getFactionDefaults(String factionName) {
        return factionTemplates.getOrDefault(factionName, new HashMap());
    }

    public static Map<String, FactionTradeListTemplate> getDefaults() {
        return defaultTemplates;
    }

    public static void saveTradeList(FactionTradeListTemplate list) {
        defaultTemplates.put(list.getName(), list);
        FactionTradeListRegistry.saveTradeLists();
    }

    private static void saveTradeLists() {
        JsonObject parent = new JsonObject();
        parent.add("defaults", (JsonElement)FactionTradeListRegistry.serializeTradeLists(defaultTemplates.values()));
        parent.add("faction_defaults", (JsonElement)FactionTradeListRegistry.serializeFactionsTradeLists());
        File file = new File("config/ancientwarfare/registry/npc/faction_trade_lists.json");
        JsonHelper.saveJsonFile(parent, file);
    }

    private static JsonObject serializeFactionsTradeLists() {
        JsonObject factionTradeLists = new JsonObject();
        for (Map.Entry<String, Map<String, FactionTradeListTemplate>> entry : factionTemplates.entrySet()) {
            factionTradeLists.add(entry.getKey(), (JsonElement)FactionTradeListRegistry.serializeTradeLists(entry.getValue().values()));
        }
        return factionTradeLists;
    }

    private static JsonArray serializeTradeLists(Collection<FactionTradeListTemplate> templateLists) {
        JsonArray tradeLists = new JsonArray();
        for (FactionTradeListTemplate templateList : templateLists) {
            tradeLists.add((JsonElement)FactionTradeListRegistry.serializeTradeList(templateList));
        }
        return tradeLists;
    }

    private static JsonObject serializeTradeList(FactionTradeListTemplate templateList) {
        JsonObject tradeList = new JsonObject();
        tradeList.addProperty("name", templateList.getName());
        tradeList.add("trades", (JsonElement)FactionTradeListRegistry.serializeTrades(templateList));
        return tradeList;
    }

    private static JsonArray serializeTrades(FactionTradeListTemplate templateList) {
        JsonArray trades = new JsonArray();
        for (FactionTradeTemplate template : templateList.getTrades()) {
            trades.add((JsonElement)FactionTradeListRegistry.serializeTrade(template));
        }
        return trades;
    }

    private static JsonObject serializeTrade(FactionTradeTemplate template) {
        JsonObject trade = new JsonObject();
        trade.add("input", (JsonElement)FactionTradeListRegistry.serializeStacks(template.getInput()));
        trade.add("output", (JsonElement)FactionTradeListRegistry.serializeStacks(template.getOutput()));
        trade.addProperty("refill_frequency", (Number)template.getRefillFrequency());
        trade.addProperty("max_trades", (Number)template.getMaxTrades());
        return trade;
    }

    private static JsonArray serializeStacks(List<ItemStack> stacks) {
        JsonArray ret = new JsonArray();
        for (ItemStack stack : stacks) {
            if (stack.func_190926_b()) continue;
            ret.add(ItemTools.serializeToJson(stack));
        }
        return ret;
    }

    public static void saveFactionTradeList(FactionTradeListTemplate list, String faction) {
        if (!factionTemplates.containsKey(faction)) {
            factionTemplates.put(faction, new HashMap());
        }
        factionTemplates.get(faction).put(list.getName(), list);
        FactionTradeListRegistry.saveTradeLists();
    }

    public static class Parser
    implements IRegistryDataParser {
        @Override
        public String getName() {
            return "faction_trade_lists";
        }

        @Override
        public void parse(JsonObject json) {
            defaultTemplates = this.parseTradeLists(JsonUtils.func_151214_t((JsonObject)json, (String)"defaults"));
            this.parseFactionDefaults(json);
        }

        private void parseFactionDefaults(JsonObject json) {
            factionTemplates = JsonHelper.mapFromJson(json, "faction_defaults", Map.Entry::getKey, e -> this.parseTradeLists(JsonUtils.func_151207_m((JsonElement)((JsonElement)e.getValue()), (String)"trade_list")));
        }

        private Map<String, FactionTradeListTemplate> parseTradeLists(JsonArray tradeLists) {
            HashMap<String, FactionTradeListTemplate> ret = new HashMap<String, FactionTradeListTemplate>();
            for (JsonElement tradeListElement : tradeLists) {
                JsonObject tradeList = JsonUtils.func_151210_l((JsonElement)tradeListElement, (String)"trade_list");
                String name = JsonUtils.func_151200_h((JsonObject)tradeList, (String)"name");
                JsonArray tradesArray = JsonUtils.func_151214_t((JsonObject)tradeList, (String)"trades");
                List<FactionTradeTemplate> trades = this.parseTrades(tradesArray);
                ret.put(name, new FactionTradeListTemplate(name, trades));
            }
            return ret;
        }

        private List<FactionTradeTemplate> parseTrades(JsonArray trades) {
            ArrayList<FactionTradeTemplate> ret = new ArrayList<FactionTradeTemplate>();
            for (JsonElement tradeElement : trades) {
                List<ItemStack> output;
                List<ItemStack> input;
                JsonObject trade = JsonUtils.func_151210_l((JsonElement)tradeElement, (String)"trade");
                int refillFrequency = JsonUtils.func_151203_m((JsonObject)trade, (String)"refill_frequency");
                int maxTrades = JsonUtils.func_151203_m((JsonObject)trade, (String)"max_trades");
                try {
                    input = JsonHelper.getItemStacks(JsonUtils.func_151214_t((JsonObject)trade, (String)"input"));
                    output = JsonHelper.getItemStacks(JsonUtils.func_151214_t((JsonObject)trade, (String)"output"));
                }
                catch (MissingResourceException ex) {
                    AncientWarfareNPC.LOG.error("Error parsing trade: ", (Throwable)ex);
                    continue;
                }
                ret.add(new FactionTradeTemplate(input, output, refillFrequency, maxTrades));
            }
            return ret;
        }
    }
}

