/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.registry;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;

public class FactionDefinition {
    private String name;
    private int color;
    private final Set<String> hostileTowards;
    private final Set<String> targetList;
    private Map<String, NBTTagCompound> themedBlocksTags = new HashMap<String, NBTTagCompound>();
    private StandingSettings standingSettings;

    FactionDefinition(StandingSettings standingSettings, Set<String> hostileTowards, Set<String> targetList) {
        this.standingSettings = standingSettings;
        this.hostileTowards = hostileTowards;
        this.targetList = targetList;
    }

    private FactionDefinition(String name, int color, StandingSettings standingSettings, Set<String> hostileTowards, Set<String> targetList, Map<String, NBTTagCompound> themedBlocksTags) {
        this(standingSettings, hostileTowards, targetList);
        this.name = name;
        this.color = color;
        this.themedBlocksTags = themedBlocksTags;
    }

    public String getName() {
        return this.name;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isHostileTowards(String otherFactionName) {
        return this.hostileTowards.contains(otherFactionName);
    }

    public CopyBuilder copy(String name, int color) {
        return new CopyBuilder(name, color, this.standingSettings.copy(), new HashSet<String>(this.hostileTowards), new HashSet<String>(this.targetList), new HashMap<String, NBTTagCompound>(this.themedBlocksTags));
    }

    public StandingSettings getStandingSettings() {
        return this.standingSettings;
    }

    public boolean isTarget(Entity entity) {
        return EntityRegistry.getEntry(entity.getClass()) != null && this.targetList.contains(EntityRegistry.getEntry(entity.getClass()).getRegistryName().toString());
    }

    public Map<String, NBTTagCompound> getThemedBlocksTags() {
        return this.themedBlocksTags;
    }

    public static class CopyBuilder {
        private final String name;
        private final int color;
        private final Set<String> hostileTowards;
        private Set<String> targetList;
        private Map<String, NBTTagCompound> themedBlocksTags;
        private final StandingSettings standingSettings;

        private CopyBuilder(String name, int color, StandingSettings standingSettings, Set<String> hostileTowards, Set<String> targetList, Map<String, NBTTagCompound> themedBlocksTags) {
            this.name = name;
            this.color = color;
            this.standingSettings = standingSettings;
            this.hostileTowards = hostileTowards;
            this.targetList = targetList;
            this.themedBlocksTags = themedBlocksTags;
        }

        public void setStandingSettings(Consumer<StandingSettings> setValues) {
            setValues.accept(this.standingSettings);
        }

        void addHostileTowards(String faction) {
            this.hostileTowards.add(faction);
        }

        void removeHostileTowards(String faction) {
            this.hostileTowards.remove(faction);
        }

        void overrideTargetList(Set<String> targetList) {
            this.targetList = targetList;
        }

        void overrideThemedBlocksTags(Map<String, NBTTagCompound> themedBlocksTags) {
            this.themedBlocksTags = themedBlocksTags;
        }

        public FactionDefinition build() {
            return new FactionDefinition(this.name, this.color, this.standingSettings, this.hostileTowards, this.targetList, this.themedBlocksTags);
        }
    }

    public static class StandingSettings {
        private int playerDefaultStanding;
        private boolean standingCanChange;
        private final Map<String, Integer> standingChanges;

        public StandingSettings(int playerDefaultStanding, boolean standingCanChange, Map<String, Integer> standingChanges) {
            this.playerDefaultStanding = playerDefaultStanding;
            this.standingCanChange = standingCanChange;
            this.standingChanges = standingChanges;
        }

        public StandingSettings copy() {
            return new StandingSettings(this.playerDefaultStanding, this.standingCanChange, new HashMap<String, Integer>(this.standingChanges));
        }

        public int getPlayerDefaultStanding() {
            return this.playerDefaultStanding;
        }

        public void setPlayerDefaultStanding(int playerDefaultStanding) {
            this.playerDefaultStanding = playerDefaultStanding;
        }

        public boolean canPlayerStandingChange() {
            return this.standingCanChange;
        }

        public void setStandingCanChange(boolean standingCanChange) {
            this.standingCanChange = standingCanChange;
        }

        public Integer getStandingChange(String changeName) {
            if (!this.standingChanges.containsKey(changeName)) {
                AncientWarfareNPC.LOG.error("{} standing change doesn't have value defined, using 0", (Object)changeName);
                return 0;
            }
            return this.standingChanges.get(changeName);
        }

        void overrideStandingChanges(Map<String, Integer> standingChanges) {
            this.standingChanges.putAll(standingChanges);
        }
    }
}

