/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.network;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.npc.faction.FactionEntry;
import net.shadowmage.ancientwarfare.npc.gamedata.TeamData;

public class PacketTeamStandingsUpdate
extends PacketBase {
    private ResourceLocation teamName;
    private FactionEntry factionEntry;

    public PacketTeamStandingsUpdate() {
    }

    public PacketTeamStandingsUpdate(ResourceLocation teamName, FactionEntry factionEntry) {
        this.teamName = teamName;
        this.factionEntry = factionEntry;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        PacketBuffer buffer = new PacketBuffer(data);
        buffer.func_180714_a(this.teamName.toString());
        buffer.func_150786_a(this.factionEntry.writeToNBT(new NBTTagCompound()));
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        this.teamName = new ResourceLocation(buffer.func_150789_c(100));
        NBTTagCompound tag = buffer.func_150793_b();
        this.factionEntry = tag == null ? null : new FactionEntry(tag);
    }

    @Override
    protected void execute(EntityPlayer player) {
        TeamData teamData = AWGameData.INSTANCE.getData(player.field_70170_p, TeamData.class);
        teamData.updateTeamStandings(this.teamName, this.factionEntry);
    }
}

