/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.network;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.npc.gamedata.TeamData;

public class PacketTeamMembershipUpdate
extends PacketBase {
    private ResourceLocation teamName;
    private String playerName;
    private Action action;

    public PacketTeamMembershipUpdate() {
    }

    public PacketTeamMembershipUpdate(ResourceLocation teamName, String playerName, Action action) {
        this.teamName = teamName;
        this.playerName = playerName;
        this.action = action;
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        PacketBuffer buffer = new PacketBuffer(data);
        buffer.func_180714_a(this.teamName.toString());
        buffer.func_180714_a(this.playerName);
        buffer.writeShort(this.action.getId());
    }

    @Override
    protected void readFromStream(ByteBuf data) throws IOException {
        PacketBuffer buffer = new PacketBuffer(data);
        this.teamName = new ResourceLocation(buffer.func_150789_c(100));
        this.playerName = buffer.func_150789_c(100);
        this.action = Action.fromId(buffer.readShort());
    }

    @Override
    protected void execute(EntityPlayer player) {
        TeamData teamData = AWGameData.INSTANCE.getData(player.field_70170_p, TeamData.class);
        if (this.action == Action.ADD) {
            teamData.addTeamMember(this.teamName, this.playerName);
        } else if (this.action == Action.REMOVE) {
            teamData.removeTeamMember(this.teamName, this.playerName, player.field_70170_p.func_82737_E(), false);
        }
    }

    public static enum Action {
        ADD(0),
        REMOVE(1);

        private int id;
        private static final Map<Integer, Action> VALUES;

        private Action(int id) {
            this.id = id;
        }

        public int getId() {
            return this.id;
        }

        public static Action fromId(int id) {
            return VALUES.get(id);
        }

        static {
            ImmutableMap.Builder builder = new ImmutableMap.Builder();
            for (Action action : Action.values()) {
                builder.put((Object)action.getId(), (Object)action);
            }
            VALUES = builder.build();
        }
    }
}

