/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.gamedata.FactionData;

public class PacketFactionUpdate
extends PacketBase {
    private NBTTagCompound packetData;

    public PacketFactionUpdate(NBTTagCompound tag) {
        this.packetData = tag;
    }

    public PacketFactionUpdate() {
    }

    @Override
    protected void writeToStream(ByteBuf data) {
        if (this.packetData != null) {
            try (ByteBufOutputStream outputStream = new ByteBufOutputStream(data);){
                CompressedStreamTools.func_74799_a((NBTTagCompound)this.packetData, (OutputStream)outputStream);
            }
            catch (IOException e) {
                AncientWarfareNPC.LOG.error("Error writing faction update packet data: ", (Throwable)e);
            }
        }
    }

    @Override
    protected void readFromStream(ByteBuf data) {
        try (ByteBufInputStream inputStream = new ByteBufInputStream(data);){
            this.packetData = CompressedStreamTools.func_74796_a((InputStream)inputStream);
        }
        catch (IOException e) {
            AncientWarfareNPC.LOG.error("Error reading faction update packet data: ", (Throwable)e);
        }
    }

    @Override
    protected void execute(EntityPlayer player) {
        if (this.packetData != null) {
            AWGameData.INSTANCE.getData(player.field_70170_p, FactionData.class).handlePacketData(player, this.packetData);
        }
    }
}

