/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.item;

import com.google.common.collect.Multimap;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;
import net.shadowmage.ancientwarfare.core.util.BlockTools;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.item.ItemBaseNPC;

public class ItemScythe
extends ItemBaseNPC {
    private final Item.ToolMaterial material;
    private final float attackDamage;
    protected float attackSpeed;
    private static final int HARVEST_RADIUS = 2;

    public ItemScythe(Item.ToolMaterial material, String registryName, float attackOffset, float attackSpeed) {
        super(registryName);
        this.material = material;
        this.func_77625_d(1);
        this.func_77656_e(material.func_77997_a());
        this.attackDamage = material.func_78000_c() + attackOffset;
        this.attackSpeed = attackSpeed;
        this.func_77655_b(registryName);
        this.func_77637_a(AncientWarfareNPC.TAB);
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot slot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(slot, stack);
        if (slot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.attackDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.attackSpeed, 0));
        }
        return multimap;
    }

    protected void applyPotionEffect(EntityLivingBase target) {
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        this.applyPotionEffect(target);
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, EntityPlayer player) {
        World world = player.field_70170_p;
        boolean harvestedSomething = false;
        for (BlockPos currPos : BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-2, -2, -2), (BlockPos)pos.func_177982_a(2, 2, 2))) {
            IBlockState currState = world.func_180495_p(currPos);
            Block currBlock = currState.func_177230_c();
            if (!this.isFarmable(currBlock)) continue;
            harvestedSomething = true;
            BlockTools.breakBlockAndDrop(world, currPos);
            world.func_180498_a(player, 2001, currPos, Block.func_176210_f((IBlockState)currState));
        }
        if (!harvestedSomething) {
            return false;
        }
        player.func_184614_ca().func_77972_a(2, (EntityLivingBase)player);
        return true;
    }

    private boolean isFarmable(Block block) {
        return block instanceof IPlantable;
    }
}

