/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.inventory;

import net.minecraft.entity.Entity;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.item.ItemUpkeepOrder;

public class NpcEquipmentHandler
implements IItemHandlerModifiable {
    private static final int SIZE_INVENTORY = 8;
    private final NpcBase npc;

    public NpcEquipmentHandler(NpcBase npc) {
        this.npc = npc;
    }

    public int getSlots() {
        return 8;
    }

    private int validateSlotIndex(int slot) {
        if (slot < 0 || slot >= 8) {
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + 8 + ")");
        }
        return slot;
    }

    public ItemStack getStackInSlot(int slot) {
        return this.npc.getItemStackFromSlot(this.validateSlotIndex(slot));
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.npc.getItemStackFromSlot(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!existing.func_190926_b()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)existing)) {
                return stack;
            }
            limit -= existing.func_190916_E();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.func_190916_E() > limit;
        if (!simulate) {
            if (existing.func_190926_b()) {
                this.npc.setItemStackToSlot(slot, reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack);
            } else {
                existing.func_190917_f(reachedLimit ? limit : stack.func_190916_E());
            }
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - limit)) : ItemStack.field_190927_a;
    }

    private int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.func_77976_d());
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.field_190927_a;
        }
        this.validateSlotIndex(slot);
        ItemStack existing = this.npc.getItemStackFromSlot(slot);
        if (existing.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        int toExtract = Math.min(amount, existing.func_77976_d());
        if (existing.func_190916_E() <= toExtract) {
            if (!simulate) {
                this.npc.setItemStackToSlot(slot, ItemStack.field_190927_a);
            }
            return existing;
        }
        if (!simulate) {
            this.npc.setItemStackToSlot(slot, ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)(existing.func_190916_E() - toExtract)));
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)existing, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        return slot == 7 || slot == 6 || slot > 1 && slot < 6 ? 1 : 64;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot == 7) {
            return stack.func_77973_b() instanceof ItemUpkeepOrder;
        }
        if (slot == 6) {
            return this.npc.isValidOrdersStack(stack);
        }
        if (slot > 1 && slot < 6) {
            return stack.func_77973_b().isValidArmor(stack, EntityEquipmentSlot.values()[slot], (Entity)this.npc);
        }
        return true;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlotIndex(slot);
        if (ItemStack.func_77989_b((ItemStack)this.npc.getItemStackFromSlot(slot), (ItemStack)stack)) {
            return;
        }
        this.npc.setItemStackToSlot(slot, stack);
    }
}

