/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import java.util.List;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.GuiElement;
import net.shadowmage.ancientwarfare.core.gui.elements.ItemSlot;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.NumberInput;
import net.shadowmage.ancientwarfare.core.interfaces.IWidgetSelection;
import net.shadowmage.ancientwarfare.core.util.StringTools;
import net.shadowmage.ancientwarfare.npc.container.ContainerWorkOrder;
import net.shadowmage.ancientwarfare.npc.orders.WorkOrder;

public class GuiWorkOrder
extends GuiContainerBase<ContainerWorkOrder> {
    private boolean hasChanged = false;
    private CompositeScrolled area;
    private Button routeButton;
    private Button shiftButton;

    public GuiWorkOrder(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        this.area = new CompositeScrolled(this, 0, 40, this.field_146999_f, this.field_147000_g - 40);
        this.addGuiElement(this.area);
        this.routeButton = new Button(8, 8, 100, 12, ""){

            @Override
            protected void onPressed() {
                ((ContainerWorkOrder)((Object)GuiWorkOrder.this.getContainer())).wo.togglePriority();
                GuiWorkOrder.this.hasChanged = true;
                GuiWorkOrder.this.refreshGui();
            }
        };
        this.addGuiElement(this.routeButton);
        this.shiftButton = new Button(8, 24, 100, 12, ""){

            @Override
            protected void onPressed() {
                ((ContainerWorkOrder)((Object)GuiWorkOrder.this.getContainer())).wo.toggleShift();
                GuiWorkOrder.this.hasChanged = true;
                GuiWorkOrder.this.refreshGui();
            }
        };
        this.addGuiElement(this.shiftButton);
    }

    @Override
    public void setupElements() {
        this.area.clearElements();
        String type = ((ContainerWorkOrder)((Object)this.getContainer())).wo.getPriorityType().name().toLowerCase(Locale.ENGLISH);
        this.routeButton.setText("guistrings.npc.work_priority." + type);
        type = ((ContainerWorkOrder)((Object)this.getContainer())).wo.isNightShift() ? "night" : "day";
        this.shiftButton.setText("guistrings.npc.work_shift." + type);
        List<WorkOrder.WorkEntry> entries = ((ContainerWorkOrder)((Object)this.getContainer())).wo.getEntries();
        int totalHeight = 8;
        int index = 0;
        for (WorkOrder.WorkEntry entry : entries) {
            GuiElement element = new ItemSlot(8, totalHeight + 2, new ItemStack(entry.getBlock((World)Minecraft.func_71410_x().field_71441_e)), this);
            this.area.addGuiElement(element);
            element = new Label(28, totalHeight, StringTools.formatPos(entry.getPosition()));
            this.area.addGuiElement(element);
            element = new IndexedButton(48, totalHeight + 10, 12, 12, "+", index){

                @Override
                protected void onPressed() {
                    ((ContainerWorkOrder)((Object)GuiWorkOrder.this.getContainer())).wo.increment(this.index);
                    GuiWorkOrder.this.hasChanged = true;
                    GuiWorkOrder.this.refreshGui();
                }
            };
            this.area.addGuiElement(element);
            element = new IndexedButton(60, totalHeight + 10, 12, 12, "-", index){

                @Override
                protected void onPressed() {
                    ((ContainerWorkOrder)((Object)GuiWorkOrder.this.getContainer())).wo.decrement(this.index);
                    GuiWorkOrder.this.hasChanged = true;
                    GuiWorkOrder.this.refreshGui();
                }
            };
            this.area.addGuiElement(element);
            element = new IndexedButton(72, totalHeight + 10, 60, 12, "guistrings.npc.remove_work_point", index){

                @Override
                protected void onPressed() {
                    ((ContainerWorkOrder)((Object)GuiWorkOrder.this.getContainer())).wo.remove(this.index);
                    GuiWorkOrder.this.hasChanged = true;
                    GuiWorkOrder.this.refreshGui();
                }
            };
            this.area.addGuiElement(element);
            element = new Label(172, totalHeight, "guistrings.npc.work_length");
            this.area.addGuiElement(element);
            element = new WorkEntryNumberInput(172, totalHeight + 10, 60, entry.getWorkLength() / 1200, this, entry){

                @Override
                public void onValueUpdated(float value) {
                    int ticks = (int)(value * 1200.0f);
                    this.entry.setWorkLength(ticks);
                    GuiWorkOrder.this.hasChanged = true;
                }
            };
            this.area.addGuiElement(element);
            totalHeight += 25;
            ++index;
        }
        this.area.setAreaSize(totalHeight);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerWorkOrder)((Object)this.getContainer())).onClose();
        }
        return super.onGuiCloseRequested();
    }

    private class IndexedButton
    extends Button {
        final int index;

        public IndexedButton(int topLeftX, int topLeftY, int width, int height, String text, int index) {
            super(topLeftX, topLeftY, width, height, text);
            this.index = index;
        }
    }

    private class WorkEntryNumberInput
    extends NumberInput {
        final WorkOrder.WorkEntry entry;

        public WorkEntryNumberInput(int topLeftX, int topLeftY, int width, float defaultText, IWidgetSelection selector, WorkOrder.WorkEntry e) {
            super(topLeftX, topLeftY, width, defaultText, selector);
            this.entry = e;
        }
    }
}

