/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gui;

import electroblob.wizardry.spell.Spell;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.util.text.translation.I18n;
import net.shadowmage.ancientwarfare.core.container.ContainerBase;
import net.shadowmage.ancientwarfare.core.gui.GuiContainerBase;
import net.shadowmage.ancientwarfare.core.gui.elements.Button;
import net.shadowmage.ancientwarfare.core.gui.elements.CompositeScrolled;
import net.shadowmage.ancientwarfare.core.gui.elements.Label;
import net.shadowmage.ancientwarfare.core.gui.elements.Text;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionSpellcasterWizardry;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFactionSpellcasterWizardry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;

public class GuiNpcFactionSpellcasterWizardry
extends GuiContainerBase<ContainerNpcFactionSpellcasterWizardry> {
    private Text spellFilterInput;
    private CompositeScrolled selectionArea;
    private CompositeScrolled assignedSpellsArea;
    private Label selection;
    Button button;
    private boolean hasChanged = false;

    public GuiNpcFactionSpellcasterWizardry(ContainerBase container) {
        super(container);
    }

    @Override
    public void initElements() {
        this.field_146999_f = 295;
        this.field_147000_g = 240;
        this.addGuiElement(new Button(this.field_146999_f - 55 - 8, 8, 55, 12, "guistrings.done"){

            @Override
            protected void onPressed() {
                ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).addSlots();
                GuiNpcFactionSpellcasterWizardry.this.closeGui();
            }
        });
        Label label = new Label(10, 43, "guistrings.npc.search");
        this.addGuiElement(label);
        Label current = new Label(147, 55, "guistrings.npc.current_spells");
        this.addGuiElement(current);
        this.selection = new Label(8, 20, "");
        this.addGuiElement(this.selection);
        this.spellFilterInput = new Text(8, 54, 116, "", this){

            @Override
            protected void handleKeyInput(int keyCode, char ch) {
                super.handleKeyInput(keyCode, ch);
                GuiNpcFactionSpellcasterWizardry.this.refreshGui();
            }
        };
        this.addGuiElement(this.spellFilterInput);
        this.selectionArea = new CompositeScrolled(this, 0, 70, 143, 168);
        this.addGuiElement(this.selectionArea);
        this.assignedSpellsArea = new CompositeScrolled(this, 143, 70, 143, 168);
        this.addGuiElement(this.assignedSpellsArea);
        for (int i = 0; i < 5; ++i) {
            String name = I18n.func_74838_a((String)("entity.ancientwarfarenpc." + ((NpcFactionSpellcasterWizardry)((ContainerNpcFactionSpellcasterWizardry)this.getContainer()).entity).getNpcFullType() + "." + (i + 1) + ".name"));
            final String presetSubtypeName = "spellcaster." + (i + 1);
            if (NpcDefaultsRegistry.getFactionNpcDefault(((NpcFactionSpellcasterWizardry)((ContainerNpcFactionSpellcasterWizardry)this.getContainer()).entity).getFaction(), presetSubtypeName).isEnabled()) {
                int y;
                int x;
                if (i < 2) {
                    x = 8;
                    y = 8 + 15 * i;
                } else {
                    x = 120;
                    y = 8 + 15 * (i - 2);
                }
                this.button = new Button(x, y, 100, 12, name){

                    @Override
                    protected void onPressed() {
                        GuiNpcFactionSpellcasterWizardry.this.hasChanged = true;
                        ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).setNameAndPresetDefaults(presetSubtypeName);
                        ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).sendChangesToServer();
                        GuiNpcFactionSpellcasterWizardry.this.refreshGui();
                    }
                };
            }
            this.addGuiElement(this.button);
        }
    }

    @Override
    public void setupElements() {
        this.selectionArea.clearElements();
        int selectionAreaHeight = 8;
        ArrayList<Spell> castableSpells = new ArrayList<Spell>();
        castableSpells.addAll(((ContainerNpcFactionSpellcasterWizardry)this.getContainer()).getAllSpells());
        for (Spell currSpell : castableSpells.stream().filter(spell -> spell.getDisplayName().toLowerCase().contains(this.spellFilterInput.getText().toLowerCase())).sorted(Comparator.comparing(spell -> spell.getDisplayName().toLowerCase())).collect(Collectors.toList())) {
            SpellAddButton spellAddButton = new SpellAddButton(8, selectionAreaHeight, currSpell);
            this.selectionArea.addGuiElement(spellAddButton);
            selectionAreaHeight += 12;
        }
        this.selectionArea.setAreaSize(selectionAreaHeight + 8);
        this.assignedSpellsArea.clearElements();
        int assignedSpellsAreaHeight = 8;
        List<Spell> assignedSpells = ((ContainerNpcFactionSpellcasterWizardry)this.getContainer()).getAssignedSpells();
        for (Spell currSpell : assignedSpells.stream().sorted(Comparator.comparing(spell -> spell.getDisplayName().toLowerCase())).collect(Collectors.toList())) {
            SpellRemoveButton assignedSpellButton = new SpellRemoveButton(8, assignedSpellsAreaHeight, currSpell);
            this.assignedSpellsArea.addGuiElement(assignedSpellButton);
            assignedSpellsAreaHeight += 12;
        }
        this.assignedSpellsArea.setAreaSize(assignedSpellsAreaHeight + 8);
    }

    @Override
    protected boolean onGuiCloseRequested() {
        if (this.hasChanged) {
            ((ContainerNpcFactionSpellcasterWizardry)this.getContainer()).sendChangesToServer();
        }
        ((NpcFactionSpellcasterWizardry)((ContainerNpcFactionSpellcasterWizardry)this.getContainer()).entity).openGUI(this.player);
        return false;
    }

    private class SpellRemoveButton
    extends Button {
        private Spell spell;

        private SpellRemoveButton(int topLeftX, int topLeftY, Spell spell) {
            super(topLeftX, topLeftY, 115, 12, spell.getDisplayName());
            this.spell = spell;
        }

        @Override
        protected void onPressed() {
            GuiNpcFactionSpellcasterWizardry.this.hasChanged = true;
            ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).removeSpell(this.spell);
            ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).sendChangesToServer();
            GuiNpcFactionSpellcasterWizardry.this.refreshGui();
        }
    }

    private class SpellAddButton
    extends Button {
        private Spell spell;

        private SpellAddButton(int topLeftX, int topLeftY, Spell spell) {
            super(topLeftX, topLeftY, 115, 12, spell.getDisplayName());
            this.spell = spell;
        }

        @Override
        protected void onPressed() {
            GuiNpcFactionSpellcasterWizardry.this.hasChanged = true;
            ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).addSpell(this.spell);
            ((ContainerNpcFactionSpellcasterWizardry)GuiNpcFactionSpellcasterWizardry.this.getContainer()).sendChangesToServer();
            GuiNpcFactionSpellcasterWizardry.this.refreshGui();
        }
    }
}

