/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.gamedata;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.util.NBTHelper;
import net.shadowmage.ancientwarfare.npc.faction.FactionEntry;
import net.shadowmage.ancientwarfare.npc.faction.PlayerFactionEntry;
import net.shadowmage.ancientwarfare.npc.gamedata.FactionData;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;

public class Team {
    private final ResourceLocation teamName;
    private Set<String> playerMembers = new HashSet<String>();
    private FactionEntry factionStandings = new FactionEntry();

    public FactionEntry getFactionStandings() {
        return this.factionStandings;
    }

    public void setFactionStandings(FactionEntry factionStandings) {
        this.factionStandings = factionStandings;
    }

    public Team(ResourceLocation teamName) {
        this.teamName = teamName;
    }

    public void addMember(String playerName) {
        if (!this.playerMembers.contains(playerName)) {
            this.playerMembers.add(playerName);
        }
    }

    public void updateFactionStandings(FactionData factionData, String playerName) {
        PlayerFactionEntry playerEntry = factionData.getEntryFor(playerName);
        for (String factionName : FactionRegistry.getFactionNames()) {
            this.updateFactionStanding(factionName, playerEntry, factionData);
        }
    }

    private void updateFactionStanding(String factionName, PlayerFactionEntry playerEntry, FactionData factionData) {
        int newTeamStanding;
        int newPlayerStanding = playerEntry.getStandingFor(factionName);
        if (this.playerMembers.size() == 1) {
            newTeamStanding = newPlayerStanding;
        } else {
            int currentTeamStanding = this.factionStandings.getStandingFor(factionName);
            newTeamStanding = (currentTeamStanding * (this.playerMembers.size() - 1) + newPlayerStanding) / this.playerMembers.size();
            this.updateMembersStanding(factionName, factionData, newTeamStanding - currentTeamStanding, playerEntry.playerName);
        }
        this.factionStandings.setStandingFor(factionName, newTeamStanding);
    }

    private void updateMembersStanding(String factionName, FactionData factionData, int teamStandingChange, String playerToExclude) {
        for (String playerName : this.playerMembers) {
            if (playerName.equals(playerToExclude)) continue;
            int currentPlayerStanding = factionData.getEntryFor(playerName).getStandingFor(factionName);
            factionData.setStandingFor(playerName, factionName, currentPlayerStanding + teamStandingChange / this.playerMembers.size());
        }
    }

    public void removeMember(String playerName) {
        this.playerMembers.remove(playerName);
    }

    public boolean isMember(String playerName) {
        return this.playerMembers.contains(playerName);
    }

    public int getFactionStanding(String factionName) {
        return this.factionStandings.getStandingFor(factionName);
    }

    public ResourceLocation getName() {
        return this.teamName;
    }

    public void adjustStandingFor(World world, FactionData factionData, String factionName, int standingChange, String playerToExclude) {
        this.factionStandings.adjustStandingFor(factionName, standingChange);
        if (this.playerMembers.size() > 1) {
            int individualMemberSplit = standingChange / this.playerMembers.size();
            this.playerMembers.forEach(playerName -> {
                if (!playerName.equals(playerToExclude)) {
                    factionData.adjustStandingFor(world, (String)playerName, factionName, individualMemberSplit);
                }
            });
        }
    }

    public NBTTagCompound serializeNBT() {
        NBTTagCompound ret = new NBTTagCompound();
        ret.func_74778_a("teamName", this.teamName.toString());
        ret.func_74782_a("playerMembers", (NBTBase)NBTHelper.getNBTStringList(this.playerMembers));
        ret.func_74782_a("factionStandings", (NBTBase)this.factionStandings.writeToNBT(new NBTTagCompound()));
        return ret;
    }

    public static Team deserializeNBT(NBTTagCompound nbt) {
        ResourceLocation teamName = new ResourceLocation(nbt.func_74779_i("teamName"));
        Team team = new Team(teamName);
        team.playerMembers = NBTHelper.getStringSet(nbt.func_150295_c("playerMembers", 8));
        team.factionStandings = new FactionEntry(nbt.func_74775_l("factionStandings"));
        return team;
    }

    public Set<String> getMembers() {
        return this.playerMembers;
    }

    public void setFactionStanding(String factionName, int standing) {
        this.factionStandings.setStandingFor(factionName, standing);
    }
}

