/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.vehicle;

import com.google.common.base.Predicate;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackNearest;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIHurt;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWatchClosest;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIOwnerHurtByTarget;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIOwnerHurtTarget;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAlarmResponse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedCommander;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedFollowCommand;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedGetFood;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedIdleWhenHungry;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIAimVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIDismountVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIFindVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIFireVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIMountVehicle;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.BlockPosTarget;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.EntityTarget;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.ITarget;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.IVehicleUser;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.TargetFactory;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;

public class NpcSiegeEngineer
extends NpcPlayerOwned
implements IVehicleUser {
    @Nullable
    private VehicleBase vehicle = null;
    private ITarget target = TargetFactory.NONE;

    @Override
    public Optional<ITarget> getTarget() {
        return this.target == TargetFactory.NONE ? Optional.empty() : Optional.of(this.target);
    }

    private void setTarget(BlockPos pos) {
        this.target = new BlockPosTarget(pos);
    }

    @Override
    public void resetTarget() {
        this.target = TargetFactory.NONE;
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase entity) {
        super.func_70624_b(entity);
        if (entity != null) {
            this.target = new EntityTarget(entity);
        } else {
            this.resetTarget();
        }
    }

    public NpcSiegeEngineer(World world) {
        super(world);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor(this, true));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIPlayerOwnedFollowCommand(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIPlayerOwnedAlarmResponse(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new NpcAIPlayerOwnedGetFood(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new NpcAIPlayerOwnedIdleWhenHungry(this));
        this.field_70714_bg.func_75776_a(6, new NpcAIDismountVehicle<NpcSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(6, new NpcAIFindVehicle<NpcSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(7, new NpcAIMountVehicle<NpcSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(8, new NpcAIAimVehicle<NpcSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(9, new NpcAIFireVehicle<NpcSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this){

            @Override
            public boolean func_75250_a() {
                return !NpcSiegeEngineer.this.isRidingVehicle() && super.func_75250_a();
            }
        });
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new NpcAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new NpcAIPlayerOwnedCommander(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new NpcAIOwnerHurtByTarget(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new NpcAIOwnerHurtTarget(this));
        this.field_70715_bh.func_75776_a(3, (EntityAIBase)new NpcAIHurt(this));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new NpcAIAttackNearest(this, (Predicate<Entity>)((Predicate)this::isHostileTowards)));
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(120.0);
    }

    @Override
    public String getNpcSubType() {
        return "";
    }

    @Override
    public String getNpcType() {
        return "siege_engineer";
    }

    @Override
    public boolean canBeAttackedBy(Entity e) {
        return true;
    }

    @Override
    public Optional<VehicleBase> getVehicle() {
        if (this.vehicle == null || this.vehicle.field_70128_L) {
            return Optional.empty();
        }
        return Optional.of(this.vehicle);
    }

    @Override
    public void setVehicle(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    @Override
    public void resetVehicle() {
        this.vehicle = null;
    }

    @Override
    public boolean isRidingVehicle() {
        return this.getVehicle().isPresent() && this.func_184218_aH();
    }

    @Override
    public boolean canContinueRidingVehicle() {
        return this.getFoodRemaining() > 0;
    }

    @Override
    public void handlePlayerCommand(NpcCommand.Command cmd) {
        if (cmd.type == NpcCommand.CommandType.ATTACK_AREA) {
            this.setTarget(cmd.pos);
        } else if (cmd.type == NpcCommand.CommandType.CLEAR_COMMAND) {
            this.resetTarget();
        } else {
            super.handlePlayerCommand(cmd);
        }
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa % 20 == 0) {
            this.checkTargetExistence();
        }
    }

    private void checkTargetExistence() {
        if (this.target != TargetFactory.NONE && !this.target.exists(this.field_70170_p)) {
            this.target = TargetFactory.NONE;
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        TargetFactory.serializeNBT(this.target, tag);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.target = TargetFactory.deserializeFromNBT(tag);
    }
}

