/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction.attributes;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.entity.EntityLiving;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.BoolAttribute;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.ClassAttribute;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.FloatAttribute;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.IAdditionalAttribute;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.StringAttribute;

public class AdditionalAttributes {
    public static final ClassAttribute HORSE_ENTITY = new ClassAttribute("horse_entity", EntityLiving.class);
    public static final BoolAttribute BURNS_IN_SUN = new BoolAttribute("burns_in_sun");
    public static final BoolAttribute UNDEAD = new BoolAttribute("undead");
    public static final StringAttribute ENTITY_SOUND = new StringAttribute("entity_sound");
    public static final FloatAttribute HEAL_PER_TRY = new FloatAttribute("heal_per_try");
    private static final Map<String, IAdditionalAttribute<?>> ALL_ATTRIBUTES = ImmutableMap.of((Object)HORSE_ENTITY.getName(), (Object)HORSE_ENTITY, (Object)BURNS_IN_SUN.getName(), (Object)BURNS_IN_SUN, (Object)UNDEAD.getName(), (Object)UNDEAD, (Object)ENTITY_SOUND.getName(), (Object)ENTITY_SOUND, (Object)HEAL_PER_TRY.getName(), (Object)HEAL_PER_TRY);
    private static final IAdditionalAttribute<String> INVALID_ATTRIBUTE = new IAdditionalAttribute<String>(){

        @Override
        public String getName() {
            return "invalid_attribute";
        }

        @Override
        public Class<String> getValueClass() {
            return String.class;
        }

        @Override
        public Optional<String> parseValue(String value) {
            return Optional.of("invalid value");
        }
    };

    private AdditionalAttributes() {
    }

    public static IAdditionalAttribute getByName(String attributeName) {
        return ALL_ATTRIBUTES.getOrDefault(attributeName, INVALID_ATTRIBUTE);
    }
}

