/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import com.google.common.base.Predicate;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackNearest;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWatchClosest;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionHurt;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIAimVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIFindVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIFireVehicle;
import net.shadowmage.ancientwarfare.npc.ai.vehicle.NpcAIMountVehicle;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.EntityTarget;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.ITarget;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.IVehicleUser;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.TargetFactory;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;

public class NpcFactionSiegeEngineer
extends NpcFaction
implements IVehicleUser {
    private VehicleBase vehicle = null;
    private ITarget target = TargetFactory.NONE;

    public NpcFactionSiegeEngineer(World world) {
        super(world);
        this.addAI();
    }

    public NpcFactionSiegeEngineer(World world, String factionName) {
        super(world, factionName);
        this.addAI();
    }

    private void addAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor(this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 5.0f, 30.0f, 5.0f));
        this.field_70714_bg.func_75776_a(3, new NpcAIFindVehicle<NpcFactionSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(4, new NpcAIMountVehicle<NpcFactionSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(5, new NpcAIAimVehicle<NpcFactionSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(6, new NpcAIFireVehicle<NpcFactionSiegeEngineer>(this));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new NpcAIWatchClosest(this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new NpcAIFactionHurt(this, (Predicate<Entity>)((Predicate)this::isHostileTowards)));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new NpcAIAttackNearest(this, (Predicate<Entity>)((Predicate)this::isHostileTowards)));
    }

    @Override
    public String getNpcType() {
        return "siege_engineer";
    }

    @Override
    public boolean worksInRain() {
        return true;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public boolean shouldSleep() {
        return false;
    }

    @Override
    public void func_70624_b(@Nullable EntityLivingBase entity) {
        super.func_70624_b(entity);
        if (entity != null) {
            this.target = new EntityTarget(entity);
        } else {
            this.resetTarget();
        }
    }

    @Override
    public void resetTarget() {
        this.target = TargetFactory.NONE;
    }

    @Override
    public Optional<VehicleBase> getVehicle() {
        if (this.vehicle == null || this.vehicle.field_70128_L) {
            return Optional.empty();
        }
        return Optional.of(this.vehicle);
    }

    @Override
    public void setVehicle(VehicleBase vehicle) {
        this.vehicle = vehicle;
    }

    @Override
    public void resetVehicle() {
        this.vehicle = null;
    }

    @Override
    public boolean isRidingVehicle() {
        return this.getVehicle().isPresent() && this.func_184218_aH();
    }

    @Override
    public boolean canContinueRidingVehicle() {
        return true;
    }

    @Override
    public Optional<ITarget> getTarget() {
        return this.target == TargetFactory.NONE ? Optional.empty() : Optional.of(this.target);
    }
}

