/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity.faction;

import com.google.common.base.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.IRangedAttackMob;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityPotion;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.init.PotionTypes;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.potion.PotionType;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIAttackNearest;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionHurt;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionPriest;
import net.shadowmage.ancientwarfare.npc.ai.faction.NpcAIFactionRangedAttack;
import net.shadowmage.ancientwarfare.npc.entity.NoFriendlyFirePotion;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;

public class NpcFactionPriest
extends NpcFaction
implements IRangedAttackMob {
    public NpcFactionPriest(World world) {
        super(world);
        this.addAI();
    }

    public NpcFactionPriest(World world, String factionName) {
        super(world, factionName);
        this.addAI();
    }

    private void addAI() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor(this, true));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 5.0f, 30.0f, 5.0f));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIFactionPriest(this));
        this.field_70714_bg.func_75776_a(16, (EntityAIBase)new NpcAIFactionRangedAttack(this, 0.8, 20, 80));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new NpcAIFactionHurt(this, (Predicate<Entity>)((Predicate)this::isHostileTowards)));
        this.field_70715_bh.func_75776_a(15, (EntityAIBase)new NpcAIAttackNearest(this, (Predicate<Entity>)((Predicate)entity -> {
            BlockPos home;
            double dist;
            if (!this.isHostileTowards((Entity)entity)) {
                return false;
            }
            return !this.func_110175_bO() || !((dist = entity.func_70092_e((double)(home = this.func_180486_cf()).func_177958_n() + 0.5, (double)home.func_177956_o(), (double)home.func_177952_p() + 0.5)) > 900.0);
        })));
    }

    @Override
    public String getNpcType() {
        return "priest";
    }

    public void func_82196_d(EntityLivingBase target, float distanceFactor) {
        this.processWitchThrowPotionLogic(target);
    }

    private void processWitchThrowPotionLogic(EntityLivingBase target) {
        double d0 = target.field_70163_u + (double)target.func_70047_e() - (double)1.1f;
        double d1 = target.field_70165_t + target.field_70159_w - this.field_70165_t;
        double d2 = d0 - this.field_70163_u;
        double d3 = target.field_70161_v + target.field_70179_y - this.field_70161_v;
        float f = MathHelper.func_76133_a((double)(d1 * d1 + d3 * d3));
        PotionType potiontype = PotionTypes.field_185252_x;
        if (f >= 8.0f && !target.func_70644_a(MobEffects.field_76421_d)) {
            potiontype = PotionTypes.field_185246_r;
        } else if (target.func_110143_aJ() >= 8.0f && !target.func_70644_a(MobEffects.field_76436_u)) {
            potiontype = PotionTypes.field_185254_z;
        } else if (f <= 3.0f && !target.func_70644_a(MobEffects.field_76437_t) && this.field_70146_Z.nextFloat() < 0.25f) {
            potiontype = PotionTypes.field_185226_I;
        }
        EntityPotion entitypotion = this.getPotion(potiontype);
        entitypotion.field_70125_A -= -20.0f;
        entitypotion.func_70186_c(d1, d2 + (double)(f * 0.2f), d3, 0.75f, 8.0f);
        this.field_70170_p.func_184148_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, SoundEvents.field_187924_gx, this.func_184176_by(), 1.0f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        this.field_70170_p.func_72838_d((Entity)entitypotion);
    }

    private EntityPotion getPotion(PotionType potiontype) {
        return new NoFriendlyFirePotion(this.field_70170_p, (EntityLivingBase)this, PotionUtils.func_185188_a((ItemStack)new ItemStack((Item)Items.field_185155_bH), (PotionType)potiontype));
    }

    @Override
    public boolean func_70686_a(Class claz) {
        return true;
    }

    @Override
    public boolean isPassive() {
        return false;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_76436_u) {
            PotionEvent.PotionApplicableEvent event = new PotionEvent.PotionApplicableEvent((EntityLivingBase)this, potionEffect);
            MinecraftForge.EVENT_BUS.post((Event)event);
            return event.getResult() == Event.Result.ALLOW;
        }
        return super.func_70687_e(potionEffect);
    }
}

