/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import java.util.Set;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIRestrictOpenDoor;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.ai.EntityAIWatchClosest2;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemHoe;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemTool;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.shadowmage.ancientwarfare.core.interfaces.IWorkSite;
import net.shadowmage.ancientwarfare.core.interfaces.IWorker;
import net.shadowmage.ancientwarfare.core.item.ItemHammer;
import net.shadowmage.ancientwarfare.core.item.ItemQuill;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIDoor;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFleeHostiles;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIFollowPlayer;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIMoveHome;
import net.shadowmage.ancientwarfare.npc.ai.NpcAIWander;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedAlarmResponse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedFindWorksite;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedFollowCommand;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedGetFood;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedIdleWhenHungry;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedRideHorse;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedWork;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedWorkRandom;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcPlayerOwned;
import net.shadowmage.ancientwarfare.npc.item.ItemWorkOrder;
import net.shadowmage.ancientwarfare.npc.orders.WorkOrder;

public class NpcWorker
extends NpcPlayerOwned
implements IWorker {
    public BlockPos autoWorkTarget;
    private NpcAIPlayerOwnedWork workAI;
    private NpcAIPlayerOwnedWorkRandom workRandomAI;

    public NpcWorker(World par1World) {
        super(par1World);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictOpenDoor((EntityCreature)this));
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new NpcAIDoor(this, true));
        this.horseAI = new NpcAIPlayerOwnedRideHorse(this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)this.horseAI);
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIFollowPlayer(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new NpcAIPlayerOwnedFollowCommand(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIFleeHostiles(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new NpcAIPlayerOwnedAlarmResponse(this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new NpcAIPlayerOwnedGetFood(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new NpcAIPlayerOwnedIdleWhenHungry(this));
        this.workAI = new NpcAIPlayerOwnedWork(this);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)this.workAI);
        this.workRandomAI = new NpcAIPlayerOwnedWorkRandom(this);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)this.workRandomAI);
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new NpcAIMoveHome(this, 50.0f, 3.0f, 30.0f, 3.0f));
        this.field_70714_bg.func_75776_a(101, (EntityAIBase)new EntityAIWatchClosest2((EntityLiving)this, EntityPlayer.class, 3.0f, 1.0f));
        this.field_70714_bg.func_75776_a(102, (EntityAIBase)new NpcAIWander(this));
        this.field_70714_bg.func_75776_a(103, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityLiving.class, 8.0f));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new NpcAIPlayerOwnedFindWorksite(this));
    }

    @Override
    public String getNpcSubType() {
        IWorkSite.WorkType type = this.getWorkTypeFromEquipment();
        switch (type) {
            case CRAFTING: {
                return "craftsman";
            }
            case FARMING: {
                return "farmer";
            }
            case FORESTRY: {
                return "lumberjack";
            }
            case MINING: {
                return "miner";
            }
            case RESEARCH: {
                return "researcher";
            }
        }
        return "";
    }

    public void handleWorksiteBroadcast(IWorkSite site, BlockPos pos) {
    }

    @Override
    public String getNpcType() {
        return "worker";
    }

    @Override
    public float getWorkEffectiveness(IWorkSite.WorkType type) {
        if (this.canWorkAt(type)) {
            float effectiveness = 1.0f + (float)this.getLevelingStats().getLevel() * 0.05f;
            Item item = this.func_184614_ca().func_77973_b();
            if (item instanceof ItemTool) {
                effectiveness += ((ItemTool)item).field_77862_b.func_77998_b() * 0.05f;
            } else if (item instanceof ItemHoe) {
                Item.ToolMaterial mat = Item.ToolMaterial.valueOf((String)((ItemHoe)item).func_77842_f());
                effectiveness += mat.func_77998_b() * 0.05f;
            } else if (item instanceof ItemHammer) {
                effectiveness += ((ItemHammer)item).getMaterial().func_77998_b() * 0.05f;
            } else if (item instanceof ItemQuill) {
                effectiveness += ((ItemQuill)item).getMaterial().func_77998_b() * 0.05f;
            }
            return effectiveness;
        }
        return 0.0f;
    }

    @Override
    public boolean shouldSleep() {
        WorkOrder order = WorkOrder.getWorkOrder(this.ordersStack);
        if (order == null || !order.isNightShift()) {
            return super.shouldSleep();
        }
        return WorldTools.isDaytimeInDimension(this.field_70170_p);
    }

    @Override
    public double getWorkRangeSq() {
        return AWNPCStatics.npcActionRange * AWNPCStatics.npcActionRange;
    }

    @Override
    public boolean canWorkAt(IWorkSite.WorkType type) {
        return type == this.getWorkTypeFromEquipment();
    }

    @Override
    public boolean isValidOrdersStack(ItemStack stack) {
        return !stack.func_190926_b() && stack.func_77973_b() instanceof ItemWorkOrder;
    }

    protected IWorkSite.WorkType getWorkTypeFromEquipment() {
        ItemStack stack = this.func_184614_ca();
        if (!stack.func_190926_b()) {
            if (stack.func_77973_b() instanceof ItemHoe) {
                return IWorkSite.WorkType.FARMING;
            }
            Set tools = stack.func_77973_b().getToolClasses(stack);
            if (tools.contains("axe")) {
                return IWorkSite.WorkType.FORESTRY;
            }
            if (tools.contains("pickaxe")) {
                return IWorkSite.WorkType.MINING;
            }
            if (tools.contains("hammer")) {
                return IWorkSite.WorkType.CRAFTING;
            }
            if (tools.contains("quill")) {
                return IWorkSite.WorkType.RESEARCH;
            }
        }
        return IWorkSite.WorkType.NONE;
    }

    @Override
    public void onOrdersInventoryChanged() {
        this.workAI.onOrdersChanged();
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        if (tag.func_74764_b("workAI")) {
            this.workAI.readFromNBT(tag.func_74775_l("workAI"));
        }
        if (tag.func_74764_b("workRandomAI")) {
            this.workRandomAI.readFromNBT(tag.func_74775_l("workRandomAI"));
        }
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74782_a("workAI", (NBTBase)this.workAI.writeToNBT(new NBTTagCompound()));
        tag.func_74782_a("workRandomAI", (NBTBase)this.workRandomAI.writeToNBT(new NBTTagCompound()));
    }
}

