/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.entity;

import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.INpc;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.pathfinding.PathNavigateGround;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.AncientWarfareNPC;
import net.shadowmage.ancientwarfare.npc.ai.AIHelper;
import net.shadowmage.ancientwarfare.npc.ai.owned.NpcAIPlayerOwnedRideHorse;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.IKeepFood;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.faction.NpcFaction;
import net.shadowmage.ancientwarfare.npc.init.AWNPCSounds;
import net.shadowmage.ancientwarfare.npc.npc_command.NpcCommand;
import net.shadowmage.ancientwarfare.npc.orders.UpkeepOrder;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;
import net.shadowmage.ancientwarfare.npc.registry.OwnedNpcDefault;
import net.shadowmage.ancientwarfare.npc.tile.TileTownHall;

public abstract class NpcPlayerOwned
extends NpcBase
implements IKeepFood,
INpc {
    private static final String COMMAND_TAG = "command";
    private static final String TOWN_HALL_TAG = "townHall";
    private static final String UPKEEP_POS_TAG = "upkeepPos";
    public boolean isAlarmed = false;
    private NpcCommand.Command playerIssuedCommand = NpcCommand.Command.NONE;
    private int foodValueRemaining = 0;
    NpcAIPlayerOwnedRideHorse horseAI;
    private BlockPos townHallPosition;
    private BlockPos upkeepAutoBlock;

    public NpcPlayerOwned(World par1World) {
        super(par1World);
        OwnedNpcDefault npcDefault = NpcDefaultsRegistry.getOwnedNpcDefault(this);
        npcDefault.applyPathSettings((PathNavigateGround)this.func_70661_as());
        npcDefault.applyAttributes(this);
        this.field_184655_bs = new float[]{1.0f, 1.0f, 1.0f, 1.0f};
        this.field_82174_bp = new float[]{1.0f, 1.0f};
    }

    @Override
    public int func_82143_as() {
        return super.func_82143_as() - 1;
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return this.isFemale() || this.getSkinSettings().isAlexModel() ? AWNPCSounds.HUMAN_FEMALE_HURT : AWNPCSounds.HUMAN_HURT;
    }

    @Nullable
    protected SoundEvent func_184615_bR() {
        return this.isFemale() || this.getSkinSettings().isAlexModel() ? AWNPCSounds.HUMAN_FEMALE_DEATH : AWNPCSounds.HUMAN_HURT;
    }

    public void func_70645_a(DamageSource source) {
        if (!this.field_70170_p.field_72995_K) {
            if (this.horseAI != null) {
                this.horseAI.onKilled();
            }
            this.validateTownHallPosition();
            this.getTownHall().ifPresent(townHall -> townHall.handleNpcDeath(this, source));
        }
        super.func_70645_a(source);
    }

    @Override
    protected void onRepack() {
        super.onRepack();
        if (this.horseAI != null) {
            this.horseAI.onKilled();
        }
    }

    @Override
    public final int getArmorValueOverride() {
        return -1;
    }

    @Override
    public final int getAttackDamageOverride() {
        return -1;
    }

    private void setTownHallPosition(@Nullable BlockPos pos) {
        this.townHallPosition = pos;
    }

    @Override
    public Optional<BlockPos> getTownHallPosition() {
        return Optional.ofNullable(this.townHallPosition);
    }

    public Optional<TileTownHall> getTownHall() {
        return this.getTownHallPosition().flatMap(p -> WorldTools.getTile((IBlockAccess)this.field_70170_p, p, TileTownHall.class));
    }

    public void handleTownHallBroadcast(BlockPos position) {
        this.validateTownHallPosition();
        Optional<BlockPos> townHallPos = this.getTownHallPosition();
        if (townHallPos.isPresent()) {
            BlockPos pos = townHallPos.get();
            double curDist = this.func_70092_e((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            double newDist = this.func_70092_e((double)position.func_177958_n() + 0.5, position.func_177956_o(), (double)position.func_177952_p() + 0.5);
            if (newDist < curDist) {
                this.setTownHallPosition(position);
                if (this.upkeepAutoBlock == null || this.upkeepAutoBlock.equals((Object)pos)) {
                    this.upkeepAutoBlock = position;
                }
            }
        } else {
            this.setTownHallPosition(position);
            if (this.upkeepAutoBlock == null) {
                this.upkeepAutoBlock = position;
            }
        }
        this.isAlarmed = this.getTownHall().map(t -> t.alarmActive).orElse(false);
    }

    private void validateTownHallPosition() {
        Optional<BlockPos> townHallPos = this.getTownHallPosition();
        if (!townHallPos.isPresent()) {
            return;
        }
        BlockPos pos = townHallPos.get();
        if (!this.field_70170_p.func_175667_e(pos)) {
            return;
        }
        Optional<TileTownHall> te = WorldTools.getTile((IBlockAccess)this.field_70170_p, pos, TileTownHall.class);
        if (te.isPresent() && this.hasCommandPermissions(te.get().getOwner())) {
            return;
        }
        this.setTownHallPosition(null);
    }

    public NpcCommand.Command getCurrentCommand() {
        return this.playerIssuedCommand;
    }

    public void handlePlayerCommand(NpcCommand.Command cmd) {
        if (cmd.type == NpcCommand.CommandType.ATTACK) {
            this.handleAttackCommand(cmd);
            return;
        }
        this.setPlayerCommand(cmd);
    }

    private void handleAttackCommand(NpcCommand.Command cmd) {
        EntityLivingBase elb;
        Entity e = cmd.getEntityTarget(this.field_70170_p);
        if (e instanceof EntityLivingBase && this.canTarget((Entity)(elb = (EntityLivingBase)e))) {
            this.func_70624_b(elb);
        }
        this.setPlayerCommand(NpcCommand.Command.NONE);
    }

    public void setPlayerCommand(NpcCommand.Command cmd) {
        this.playerIssuedCommand = cmd;
    }

    @Override
    public boolean isHostileTowards(Entity entityTarget) {
        if (entityTarget instanceof NpcPlayerOwned || entityTarget instanceof EntityPlayer) {
            return !this.getOwner().isOwnerOrSameTeamOrFriend(entityTarget);
        }
        if (entityTarget instanceof NpcFaction) {
            return ((NpcFaction)entityTarget).isHostileTowards((Entity)this);
        }
        return NpcDefaultsRegistry.getOwnedNpcDefault(this).isTarget(entityTarget) || AIHelper.isAdditionalEntityToTarget(entityTarget);
    }

    @Override
    public boolean canTarget(Entity e) {
        return !this.getOwner().isOwnerOrSameTeamOrFriend(e) && e instanceof EntityLivingBase;
    }

    @Override
    public boolean canBeAttackedBy(Entity e) {
        return !this.getOwner().isOwnerOrSameTeamOrFriend(e);
    }

    @Override
    public int getFoodRemaining() {
        return this.foodValueRemaining;
    }

    @Override
    public void setFoodRemaining(int food) {
        this.foodValueRemaining = food;
    }

    @Override
    public Optional<BlockPos> getUpkeepPoint() {
        return UpkeepOrder.getUpkeepOrder(this.upkeepStack).map(UpkeepOrder::getUpkeepPosition).orElse(Optional.ofNullable(this.upkeepAutoBlock));
    }

    @Override
    public void setUpkeepAutoPosition(@Nullable BlockPos pos) {
        this.upkeepAutoBlock = pos;
    }

    @Override
    public EnumFacing getUpkeepBlockSide() {
        return UpkeepOrder.getUpkeepOrder(this.upkeepStack).map(UpkeepOrder::getUpkeepBlockSide).orElse(EnumFacing.DOWN);
    }

    @Override
    public int getUpkeepDimensionId() {
        return UpkeepOrder.getUpkeepOrder(this.upkeepStack).map(UpkeepOrder::getUpkeepDimension).orElse(this.field_70170_p.field_73011_w.getDimension());
    }

    @Override
    public int getUpkeepAmount() {
        return UpkeepOrder.getUpkeepOrder(this.upkeepStack).map(UpkeepOrder::getUpkeepAmount).orElse(AWNPCStatics.npcDefaultUpkeepWithdraw);
    }

    @Override
    protected boolean tryCommand(EntityPlayer player) {
        return this.hasCommandPermissions(player.func_110124_au(), player.func_70005_c_()) && super.tryCommand(player);
    }

    protected void func_82160_b(boolean wasRecentlyHit, int lootingModifier) {
        for (EntityEquipmentSlot slot : EntityEquipmentSlot.values()) {
            ItemStack itemstack = this.func_184582_a(slot);
            if (!itemstack.func_190926_b()) {
                this.func_70099_a(itemstack, 0.0f);
            }
            this.func_184201_a(slot, ItemStack.field_190927_a);
        }
        if (!AWNPCStatics.persistOrdersOnDeath) {
            if (!this.ordersStack.func_190926_b()) {
                this.func_70099_a(this.ordersStack, 0.0f);
            }
            if (!this.upkeepStack.func_190926_b()) {
                this.func_70099_a(this.upkeepStack, 0.0f);
            }
            this.ordersStack = ItemStack.field_190927_a;
            this.upkeepStack = ItemStack.field_190927_a;
        }
    }

    public boolean withdrawFood(IItemHandler handler) {
        int amount = this.getUpkeepAmount() - this.getFoodRemaining();
        if (amount <= 0) {
            return true;
        }
        int eaten = 0;
        for (int slot = 0; slot < handler.getSlots(); ++slot) {
            ItemStack stack = handler.getStackInSlot(slot);
            int val = AncientWarfareNPC.statics.getFoodValue(stack);
            if (val <= 0) continue;
            while (eaten < amount && !stack.func_190926_b()) {
                eaten += val;
                handler.extractItem(slot, 1, false);
            }
        }
        this.setFoodRemaining(this.getFoodRemaining() + eaten);
        return this.getFoodRemaining() >= this.getUpkeepAmount();
    }

    @Override
    protected boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        int value;
        if (this.getFoodRemaining() < this.getUpkeepAmount() && (value = AncientWarfareNPC.statics.getFoodValue(player.func_184586_b(hand))) > 0) {
            if (!this.field_70170_p.field_72995_K) {
                player.func_184586_b(hand).func_190918_g(1);
            }
            this.foodValueRemaining += value;
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.foodValueRemaining > 0 && !this.isSleeping()) {
            --this.foodValueRemaining;
        }
    }

    @Nullable
    public Entity func_184204_a(int dimensionIn) {
        this.townHallPosition = null;
        this.upkeepAutoBlock = null;
        return super.func_184204_a(dimensionIn);
    }

    @Override
    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.foodValueRemaining = tag.func_74762_e("foodValue");
        if (tag.func_74764_b(COMMAND_TAG)) {
            this.playerIssuedCommand = new NpcCommand.Command(tag.func_74775_l(COMMAND_TAG));
        }
        if (tag.func_74764_b(TOWN_HALL_TAG)) {
            this.townHallPosition = BlockPos.func_177969_a((long)tag.func_74763_f(TOWN_HALL_TAG));
        }
        if (tag.func_74764_b(UPKEEP_POS_TAG)) {
            this.upkeepAutoBlock = BlockPos.func_177969_a((long)tag.func_74763_f(UPKEEP_POS_TAG));
        }
        this.onOrdersInventoryChanged();
    }

    @Override
    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74768_a("foodValue", this.foodValueRemaining);
        if (this.playerIssuedCommand != NpcCommand.Command.NONE) {
            tag.func_74782_a(COMMAND_TAG, (NBTBase)this.playerIssuedCommand.writeToNBT(new NBTTagCompound()));
        }
        if (this.townHallPosition != null) {
            tag.func_74772_a(TOWN_HALL_TAG, this.townHallPosition.func_177986_g());
        }
        if (this.upkeepAutoBlock != null) {
            tag.func_74772_a(UPKEEP_POS_TAG, this.upkeepAutoBlock.func_177986_g());
        }
    }
}

