/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.config;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.shadowmage.ancientwarfare.core.config.ModConfiguration;
import net.shadowmage.ancientwarfare.npc.registry.FactionDefinition;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;

public class AWNPCStatics
extends ModConfiguration {
    public static int npcActionRange = 3;
    public static boolean repackCreativeOnly = false;
    public static boolean persistOrdersOnDeath = true;
    public static int maxNpcLevel = 10;
    public static int maxNpcWorkerLevel = 10;
    public static int maxNpcCombatLevel = 10;
    public static int npcXpFromWork = 1;
    public static int npcXpFromTrade = 1;
    public static int npcXpFromAttack = 1;
    public static int npcXpFromKill = 5;
    public static int npcXpFromMoveItem = 1;
    public static int npcWorkTicks = 50;
    public static int npcDefaultUpkeepWithdraw = 6000;
    public static boolean npcAllowUpkeepAnyInventory = true;
    public static int townMaxRange = 100;
    public static int townUpdateFreq = 100;
    public static boolean npcAIDebugMode = false;
    public static double archerRange = 60.0;
    public static boolean vanillaEquipmentDropRate = true;
    public static double npcLevelDamageMultiplier = 0.05;
    public static boolean loadDefaultSkinPack = true;
    public static Property renderAI;
    public static Property renderWorkPoints;
    public static Property renderFriendlyNames;
    public static Property renderHostileNames;
    public static Property renderFriendlyHealth;
    public static Property renderHostileHealth;
    public static Property renderTeamColors;
    private Configuration foodConfig;
    private static final String foodSettings = "01_food_settings";
    private HashMap<String, Integer> foodValues;
    private static int foodMultiplier;
    private Configuration factionConfig;
    private static final String factionSettings = "01_faction_settings";

    public AWNPCStatics(String mod) {
        super(mod);
    }

    @Override
    public void initializeCategories() {
        this.config.addCustomCategoryComment("01_shared_settings", "General Options\nAffect both client and server.  These configs must match for client and server, or\nstrange and probably BAD things WILL happen.");
        this.config.addCustomCategoryComment("02_server_settings", "Server Options\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.config.addCustomCategoryComment("03_client_settings", "Client Options\nAffect only client-side operations.  Many of these options can be set from the in-game Options GUI.\nServer admins can ignore these settings.");
        this.foodConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcFood");
        this.foodConfig.addCustomCategoryComment(foodSettings, "Food Value Options\nThe value specified is the number of ticks that the item will feed the NPC for.\nAdd a new line for each item. The item type is not checked, and the default multiplier is not applied.\n0 or under will make the item unusable as a food.\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
        this.factionConfig = AWNPCStatics.getConfigFor("AncientWarfareNpcFactionStandings");
        this.factionConfig.addCustomCategoryComment(factionSettings, "Faction Options\nSet starting faction values, and alter the amount of standing gained/lost from player actions.\nAffect only server-side operations.  Will need to be set for dedicated servers, and single\nplayer (or LAN worlds).  Clients playing on remote servers can ignore these settings.");
    }

    @Override
    public void initializeValues() {
        this.loadFoodValues();
        maxNpcLevel = this.config.get("02_server_settings", "npc_max_level", maxNpcLevel, "[DEPRECATED] Max NPC Level\nDefault=" + maxNpcLevel + "\nHow high can NPCs level up?  Npcs gain more health, attack damage, and overall\nimproved stats with each level.  Levels can go very high, but higher values may\nresult in overpowered NPCs once leveled up.").getInt();
        maxNpcWorkerLevel = this.config.get("02_server_settings", "npc_worker_max_level", maxNpcWorkerLevel, "Max Worker NPC Level\nDefault=" + maxNpcWorkerLevel + "\nHow high Worker can NPCs level up?  Npcs gain more health and overall\nimproved stats with each level.  Levels can go very high, but higher values may\nresult in overpowered NPCs once leveled up.").getInt();
        maxNpcCombatLevel = this.config.get("02_server_settings", "npc_combat_max_level", maxNpcCombatLevel, "Max Combat NPC Level\nDefault=" + maxNpcCombatLevel + "\nHow high Combat can NPCs level up?  Npcs gain more health, attack damage, and overall\nimproved stats with each level.  Levels can go very high, but higher values may\nresult in overpowered NPCs once leveled up.").getInt();
        npcXpFromAttack = this.config.get("02_server_settings", "npc_xp_per_attack", npcXpFromAttack, "XP Per Attack\nDefault=" + npcXpFromAttack + "\nHow much xp should an NPC gain each time they damage but do not kill an enemy?\nHigher values will result in faster npc leveling.\nApplies to both player-owned and faction-based NPCs.").getInt();
        npcXpFromKill = this.config.get("02_server_settings", "npc_xp_per_kill", npcXpFromKill, "XP Per Kill\nDefault=" + npcXpFromKill + "\nHow much xp should an NPC gain each time they kill an enemy?\nHigher values will result in faster npc leveling.\nApplies to both player-owned and faction-based NPCs.").getInt();
        npcLevelDamageMultiplier = this.config.get("02_server_settings", "npc_level_damage_multiplier", npcLevelDamageMultiplier, "NPC damage bonus per npc level\nDefault=" + npcLevelDamageMultiplier + "\nBy default at level 10 they do 2x the damage as at lvl 0.\nHigher values will result in more damage.\nApplies to player-owned and faction-based NPCs.").getDouble();
        npcXpFromTrade = this.config.get("02_server_settings", "npc_xp_per_trade", npcXpFromTrade, "XP Per Trade\nDefault=" + npcXpFromTrade + "\nHow much xp should an NPC gain each time successfully traded with?\nHigher values will result in faster npc leveling and unlock more trade recipes.\nApplies to both player-owned and faction-based NPCs.").getInt();
        npcXpFromWork = this.config.get("02_server_settings", "npc_xp_per_work", npcXpFromWork, "XP Per Work\nDefault=" + npcXpFromWork + "\nHow much xp should an NPC gain each time it works at a worksite?\nHigher values will result in faster npc leveling.\nApplies to player-owned NPCs only.").getInt();
        npcXpFromMoveItem = this.config.get("02_server_settings", "npc_xp_per_item_moved", npcXpFromMoveItem, "XP Per Courier\nDefault=" + npcXpFromMoveItem + "\nHow much xp should an NPC gain each time it moves an item?\nHigher values will result in faster npc leveling.\nApplies to player-owned NPCs only.").getInt();
        npcWorkTicks = this.config.get("02_server_settings", "npc_work_ticks", npcWorkTicks, "Time Between Work Ticks\nDefault=" + npcWorkTicks + "\nHow many game ticks should pass between workers' processing work at a work-site.\nLower values result in more work output, higher values result in less work output.").getInt();
        npcAllowUpkeepAnyInventory = this.config.get("02_server_settings", "allow_upkeep_any_inventory", npcAllowUpkeepAnyInventory, "Allow NPC upkeep location at any inventory\nDefault=" + npcAllowUpkeepAnyInventory + "\nBy default, the Upkeep Order slip can be used to assign upkeep locations to any valid inventory block.\nIf set to false, only Town Hall blocks will be allowed as valid upkeep locations.").getBoolean();
        townMaxRange = this.config.get("02_server_settings", "town_hall_max_range", townMaxRange, "Town Hall Max Activation Range\nDefault=" + townMaxRange + "\nHow many blocks can a Town Hall be away from an NPC, while still detecting their death for possible resurrection.\nThis is a maximum, for server efficiency sake. Lower individual values can be setup from each block interaction GUI.").getInt();
        townUpdateFreq = this.config.get("02_server_settings", "town_hall_ticks", townUpdateFreq, "Default=" + townUpdateFreq + "\nHow many game ticks should pass between Town Hall updates.This affect how an NPC can change its selected Town Hall by moving to different places.\nLower values will make an NPC change its Town Hall faster, but is more costly for a server.\n").getInt();
        loadDefaultSkinPack = this.config.get("03_client_settings", "load_default_skin_pack", loadDefaultSkinPack, "Load Default Skin Pack\nDefault=true\nIf true, default skin pack will be loaded.\nIf false, default skin pack will NOT be loaded -- you will need to supply your own\nskin packs or all npcs will use the default skin.").getBoolean();
        archerRange = this.config.get("02_server_settings", "archer_attack_range", archerRange, "Archer attack range\nDefault=" + archerRange + "\nAttack range of all archers, except mounted archers who are half of this value.").getDouble();
        renderAI = this.config.get("03_client_settings", "render_npc_ai", true);
        renderWorkPoints = this.config.get("03_client_settings", "render_work_points", true);
        renderFriendlyNames = this.config.get("03_client_settings", "render_friendly_nameplates", false);
        renderHostileNames = this.config.get("03_client_settings", "render_hostile_nameplates", false);
        renderFriendlyHealth = this.config.get("03_client_settings", "render_friendly_health", true);
        renderHostileHealth = this.config.get("03_client_settings", "render_hostile_health", true);
        renderTeamColors = this.config.get("03_client_settings", "render_team_colors", true);
        npcActionRange = this.config.get("01_shared_settings", "npc_action_range", npcActionRange, "Action Range\nDefault=" + npcActionRange + "\nThe range in blocks that an NPC can perform an action on something. The player has an action\nrange of 5. Only affects workers, no effect on the attack range of combat units nor medics.\nMinimum value of 3 unless you want NPC's to bug-out and get stuck at random.").getInt();
        vanillaEquipmentDropRate = this.config.get("01_shared_settings", "npc_vanilla_equipment_drop_rate", vanillaEquipmentDropRate, "Vanilla equipment drop rate for faction NPCs\nMakes Faction NPCs drop their items by the Vanilla Equipment Drop rate (8,5%)\nDefault=" + vanillaEquipmentDropRate + "\nIf set to false, the NPCs will ALWAYS drop ALL equipment they have (100%) rate").getBoolean();
        repackCreativeOnly = this.config.get("01_shared_settings", "npc_repack_creative_only", repackCreativeOnly, "Repack only available for Creative players?\nDefault=" + repackCreativeOnly + "\nIf true, the 'Repack' option for NPC's will be unavailable outside of Creative mode.").getBoolean();
        persistOrdersOnDeath = this.config.get("01_shared_settings", "npc_death_keep_orders_items", persistOrdersOnDeath, "NPC's will keep orders items on death?\nDefault=" + persistOrdersOnDeath + "\nIf true, an NPC who dies and manages to notify a nearby town hall will keep their orders items on their body. So if/when a priest resurrects them, they will have the orders items on them still. If there is no Town Hall nearby to catch the death however, the will drop on the ground as normal.").getBoolean();
    }

    public int getPlayerDefaultStanding(String factionName) {
        FactionDefinition.StandingSettings standingSettings = FactionRegistry.getFaction(factionName).getStandingSettings();
        if (!standingSettings.canPlayerStandingChange()) {
            return standingSettings.getPlayerDefaultStanding();
        }
        return this.factionConfig.get(factionSettings, factionName + ".starting_faction_standing", standingSettings.getPlayerDefaultStanding(), "Default faction standing for: [" + factionName + "] for new players joining a game. Less than 0 will be hostile, greater than or equal to zero will be neutral/friendly. Players will need to trade with faction-owned traders to improve their standing to become friendly.").getInt();
    }

    private void loadFoodValues() {
        foodMultiplier = this.foodConfig.getInt("food_multiplier", "Default", foodMultiplier, 0, 0xCCCCCCC, "Food items which don't have a custom duration time set will have their nourishing amount multiplied by this number, to get the number of ticks feeding the npc.");
        this.foodConfig.get(foodSettings, "minecraft:apple", 3000, "Example of a food usual tick duration. Default food multiplier included.");
        this.foodConfig.get(foodSettings, "minecraft:mushroom_stew", 4500, "Example of a food usual tick duration. Default food multiplier included.");
        this.foodConfig.get(foodSettings, "minecraft:rotten_flesh", 0, "Rotten flesh is a rejected food by default.");
        this.foodConfig.get(foodSettings, "minecraft:poisonous_potato", 0, "Poisonous potato is a rejected food by default.");
        this.foodConfig.get(foodSettings, "minecraft:spider_eye", 0, "Spider eye is a rejected food by default.");
        ConfigCategory category = this.foodConfig.getCategory(foodSettings);
        this.foodValues = new HashMap();
        for (Map.Entry entry : category.entrySet()) {
            String name = (String)entry.getKey();
            int value = ((Property)entry.getValue()).getInt(0);
            this.foodValues.put(name, value);
        }
    }

    public int getFoodValue(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        String name = stack.func_77973_b().getRegistryName().toString();
        if (this.foodValues.containsKey(name)) {
            return this.foodValues.get(name);
        }
        if (stack.func_77973_b() instanceof ItemFood) {
            int healAmount = ((ItemFood)stack.func_77973_b()).func_150905_g(stack);
            float saturationModifier = ((ItemFood)stack.func_77973_b()).func_150906_h(stack);
            return (healAmount + healAmount * (int)(saturationModifier * 2.0f)) * foodMultiplier;
        }
        return 0;
    }

    @Override
    public void save() {
        super.save();
        this.foodConfig.save();
        this.factionConfig.save();
    }

    static {
        foodMultiplier = 350;
    }
}

