/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.vehicle;

import net.shadowmage.ancientwarfare.core.util.Trig;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.ITarget;
import net.shadowmage.ancientwarfare.npc.entity.vehicle.IVehicleUser;
import net.shadowmage.ancientwarfare.vehicle.entity.VehicleBase;

public class NpcAIAimVehicle<T extends NpcBase>
extends NpcAI<T> {
    public NpcAIAimVehicle(T npc) {
        super(npc);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && ((IVehicleUser)((Object)this.npc)).getTarget().isPresent() && ((IVehicleUser)((Object)this.npc)).canContinueRidingVehicle() && ((IVehicleUser)((Object)this.npc)).isRidingVehicle() && ((IVehicleUser)((Object)this.npc)).getTarget().map(t -> ((IVehicleUser)((Object)this.npc)).getVehicle().map(v -> v.firingHelper.isAimedAt((ITarget)t)).orElse(false) == false).orElse(false) != false;
    }

    public void func_75246_d() {
        ((IVehicleUser)((Object)this.npc)).getVehicle().ifPresent(vehicle -> ((IVehicleUser)((Object)this.npc)).getTarget().ifPresent(target -> {
            if (this.turnVehicleIfYawDifferenceGreat((VehicleBase)vehicle, (ITarget)target)) {
                return;
            }
            vehicle.moveHelper.setStrafeInput((byte)0);
            vehicle.moveHelper.setForwardInput((byte)0);
            vehicle.firingHelper.handleSoldierTargetInput(target.getX(), target.getY(), target.getZ());
        }));
    }

    private boolean turnVehicleIfYawDifferenceGreat(VehicleBase vehicle, ITarget target) {
        float yawDiff = Trig.getAngleDiffSigned(vehicle.field_70177_z, vehicle.firingHelper.getAimYaw(target));
        if (!vehicle.vehicleType.canAdjustYaw() && Math.abs(yawDiff) < 2.0f) {
            vehicle.field_70177_z += yawDiff;
            vehicle.moveHelper.stopMotion();
        } else if ((vehicle.vehicleType.getBaseTurretRotationAmount() < 180.0f || Math.abs(yawDiff) > 120.0f) && !Trig.isAngleBetween(vehicle.field_70177_z + yawDiff, vehicle.localTurretRotationHome - this.getMaxRotDifference(vehicle), vehicle.localTurretRotationHome + this.getMaxRotDifference(vehicle))) {
            if (yawDiff < 0.0f) {
                vehicle.moveHelper.setStrafeInput((byte)1);
            } else {
                vehicle.moveHelper.setStrafeInput((byte)-1);
            }
            vehicle.moveHelper.setForwardInput((byte)0);
            vehicle.firingHelper.handleSoldierTargetInput(target.getX(), target.getY(), target.getZ());
            return true;
        }
        return false;
    }

    private float getMaxRotDifference(VehicleBase vehicle) {
        return Math.min(vehicle.currentTurretRotationMax + 1.5f, 180.0f);
    }

    public void func_75251_c() {
        ((IVehicleUser)((Object)this.npc)).getVehicle().ifPresent(v -> v.moveHelper.setStrafeInput((byte)0));
    }
}

