/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;
import net.shadowmage.ancientwarfare.npc.orders.CombatOrder;

public class NpcAIPlayerOwnedPatrol
extends NpcAI<NpcBase> {
    private static final int MAX_TICKS_AT_POINT = 50;
    private boolean init = false;
    private int patrolIndex;
    private boolean atPoint;
    private int ticksAtPoint;
    private CombatOrder orders;
    private ItemStack ordersStack;

    public NpcAIPlayerOwnedPatrol(NpcBase npc) {
        super(npc);
        this.func_75248_a(3);
    }

    public void onOrdersInventoryChanged() {
        this.patrolIndex = 0;
        this.ordersStack = this.npc.ordersStack;
        this.orders = CombatOrder.getCombatOrder(this.ordersStack);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (!this.init) {
            this.init = true;
            this.ordersStack = this.npc.ordersStack;
            this.orders = CombatOrder.getCombatOrder(this.ordersStack);
            if (this.orders == null || this.patrolIndex >= this.orders.size()) {
                this.patrolIndex = 0;
            }
        }
        if (this.npc.func_70638_az() != null) {
            return false;
        }
        return this.orders != null && !this.ordersStack.func_190926_b() && this.orders.getPatrolDimension() == this.npc.field_70170_p.field_73011_w.getDimension() && !this.orders.isEmpty();
    }

    public void func_75249_e() {
        this.npc.addAITask(32);
    }

    public void func_75246_d() {
        if (this.atPoint) {
            this.npc.removeAITask(512);
            ++this.ticksAtPoint;
            if (this.ticksAtPoint > 50) {
                this.setMoveToNextPoint();
            }
        } else {
            BlockPos pos = (BlockPos)this.orders.get(this.patrolIndex);
            double dist = this.npc.func_70092_e((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            if (dist > 4.0) {
                this.moveToPosition(pos, dist);
            } else {
                this.atPoint = true;
                this.ticksAtPoint = 0;
            }
        }
    }

    private void setMoveToNextPoint() {
        this.atPoint = false;
        this.ticksAtPoint = 0;
        ++this.patrolIndex;
        this.moveRetryDelay = 0;
        if (this.patrolIndex >= this.orders.size()) {
            this.patrolIndex = 0;
        }
    }

    public void func_75251_c() {
        this.ticksAtPoint = 0;
        this.moveRetryDelay = 0;
        this.npc.removeAITask(544);
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.patrolIndex = tag.func_74762_e("patrolIndex");
        this.atPoint = tag.func_74767_n("atPoint");
        this.ticksAtPoint = tag.func_74762_e("ticksAtPoint");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("patrolIndex", this.patrolIndex);
        tag.func_74757_a("atPoint", this.atPoint);
        tag.func_74768_a("ticksAtPoint", this.ticksAtPoint);
        return tag;
    }
}

