/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai.owned;

import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.shadowmage.ancientwarfare.core.owner.IOwnable;
import net.shadowmage.ancientwarfare.core.util.WorldTools;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcCourier;
import net.shadowmage.ancientwarfare.npc.orders.RoutingOrder;

public class NpcAIPlayerOwnedCourier
extends NpcAI<NpcCourier> {
    private boolean init;
    private int routeIndex;
    private int ticksToWork;
    private int ticksAtSite;
    private RoutingOrder order;
    private ItemStack routeStack;

    public NpcAIPlayerOwnedCourier(NpcCourier npc) {
        super(npc);
        this.func_75248_a(3);
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a()) {
            return false;
        }
        if (!this.init) {
            this.init = true;
            this.routeStack = ((NpcCourier)this.npc).ordersStack;
            this.order = RoutingOrder.getRoutingOrder(this.routeStack);
            if (this.order == null || this.routeIndex >= this.order.size()) {
                this.routeIndex = 0;
            }
        }
        return !((NpcCourier)this.npc).shouldBeAtHome() && ((NpcCourier)this.npc).backpackInventory != null && this.order != null && !this.order.isEmpty();
    }

    public void func_75249_e() {
        ((NpcCourier)this.npc).addAITask(16);
    }

    public void func_75246_d() {
        BlockPos pos = ((RoutingOrder.RoutePoint)this.order.get(this.routeIndex)).getTarget();
        double dist = ((NpcCourier)this.npc).func_174818_b(pos);
        if (dist > (double)(AWNPCStatics.npcActionRange * AWNPCStatics.npcActionRange)) {
            ((NpcCourier)this.npc).addAITask(512);
            this.ticksAtSite = 0;
            this.ticksToWork = 0;
            this.moveToPosition(pos, dist);
        } else {
            this.moveRetryDelay = 0;
            ((NpcCourier)this.npc).func_70661_as().func_75499_g();
            ((NpcCourier)this.npc).removeAITask(512);
            this.workAtSite();
        }
    }

    public void func_75251_c() {
        this.ticksToWork = 0;
        this.ticksAtSite = 0;
        this.moveRetryDelay = 0;
        ((NpcCourier)this.npc).func_70661_as().func_75499_g();
        ((NpcCourier)this.npc).removeAITask(528);
    }

    private void workAtSite() {
        if (this.ticksToWork == 0) {
            this.startWork();
        } else {
            ++this.ticksAtSite;
            if (((NpcCourier)this.npc).field_70173_aa % 10 == 0) {
                ((NpcCourier)this.npc).func_184609_a(EnumHand.MAIN_HAND);
            }
            if (this.ticksAtSite > this.ticksToWork) {
                this.setMoveToNextSite();
            }
        }
    }

    private void startWork() {
        IItemHandler target = this.getTargetHandler();
        if (target != null) {
            this.ticksAtSite = 0;
            int moved = this.order.handleRouteAction((RoutingOrder.RoutePoint)this.order.get(this.routeIndex), ((NpcCourier)this.npc).backpackInventory, target);
            if (moved > 0) {
                this.ticksToWork = (AWNPCStatics.npcWorkTicks - 30 - ((NpcCourier)this.npc).getLevelingStats().getLevel()) * moved;
                if (this.ticksToWork <= 0) {
                    this.ticksToWork = 0;
                }
                ((NpcCourier)this.npc).addExperience(moved * AWNPCStatics.npcXpFromMoveItem);
                return;
            }
        }
        this.setMoveToNextSite();
    }

    @Nullable
    private IItemHandler getTargetHandler() {
        RoutingOrder.RoutePoint point = (RoutingOrder.RoutePoint)this.order.get(this.routeIndex);
        return WorldTools.getTile((IBlockAccess)((NpcCourier)this.npc).field_70170_p, point.getTarget()).filter(t -> t.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, point.getBlockSide())).map(t -> this.getTargetHandler(point.getBlockSide(), (TileEntity)t)).orElse(null);
    }

    @Nullable
    private IItemHandler getTargetHandler(EnumFacing side, TileEntity te) {
        IOwnable ownableTE;
        if (te instanceof IOwnable && !((NpcCourier)this.npc).hasCommandPermissions((ownableTE = (IOwnable)te).getOwner())) {
            return null;
        }
        return (IItemHandler)te.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, side);
    }

    private void setMoveToNextSite() {
        this.ticksAtSite = 0;
        this.ticksToWork = 0;
        this.moveRetryDelay = 0;
        ++this.routeIndex;
        if (this.routeIndex >= this.order.size()) {
            this.routeIndex = 0;
        }
    }

    public void onOrdersChanged() {
        this.routeStack = ((NpcCourier)this.npc).ordersStack;
        this.order = RoutingOrder.getRoutingOrder(this.routeStack);
        this.routeIndex = 0;
        this.ticksAtSite = 0;
        this.ticksToWork = 0;
        this.moveRetryDelay = 0;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.routeIndex = tag.func_74762_e("routeIndex");
        this.ticksAtSite = tag.func_74762_e("ticksAtSite");
        this.ticksToWork = tag.func_74762_e("ticksToWork");
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("routeIndex", this.routeIndex);
        tag.func_74768_a("ticksAtSite", this.ticksAtSite);
        tag.func_74768_a("ticksToWork", this.ticksToWork);
        return tag;
    }
}

