/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.passive.AbstractHorse;
import net.minecraft.entity.passive.EntityHorse;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIRideHorse<T extends NpcBase>
extends NpcAI<T> {
    private static final AttributeModifier FOLLOW_RANGE_MODIFIER = new AttributeModifier("modifier.npc_horse_path_extension", 24.0, 0).func_111168_a(false);
    private final AttributeModifier moveSpeedModifier;
    protected EntityLiving horse;
    private final List<EntityAITasks.EntityAITaskEntry> horseAI = new ArrayList<EntityAITasks.EntityAITaskEntry>();

    public NpcAIRideHorse(T npc, double speedFactor) {
        super(npc);
        this.moveSpeedModifier = new AttributeModifier("modifier.npc_ride_speed", speedFactor, 1).func_111168_a(false);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.shouldRideHorse();
    }

    protected boolean shouldRideHorse() {
        return this.horse == null && this.npc.func_184187_bx() instanceof EntityHorse;
    }

    public void func_75249_e() {
        this.horse = (EntityLiving)this.npc.func_184187_bx();
        this.onMountHorse();
    }

    protected void onMountHorse() {
        this.removeHorseAI();
        if (this.horse instanceof AbstractHorse) {
            AbstractHorse h = (AbstractHorse)this.horse;
            h.func_110251_o(true);
            h.func_110227_p(false);
            h.func_110219_q(false);
        }
        this.applyModifiers();
    }

    public void onKilled() {
        if (this.horse != null) {
            this.onDismountHorse();
            this.horse = null;
        }
    }

    protected void onDismountHorse() {
        this.addHorseAI();
        if (this.horse instanceof AbstractHorse) {
            ((AbstractHorse)this.horse).func_110251_o(true);
            this.removeModifiers();
        }
    }

    private void applyModifiers() {
        if (this.horse instanceof AbstractHorse) {
            this.removeModifiers();
            this.horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111121_a(this.moveSpeedModifier);
            this.horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111121_a(FOLLOW_RANGE_MODIFIER);
        }
    }

    private void removeModifiers() {
        this.horse.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111124_b(this.moveSpeedModifier);
        this.horse.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111124_b(FOLLOW_RANGE_MODIFIER);
    }

    private void removeHorseAI() {
        this.horseAI.clear();
        this.horseAI.addAll(this.horse.field_70714_bg.field_75782_a);
        for (EntityAITasks.EntityAITaskEntry task : this.horseAI) {
            this.horse.field_70714_bg.func_85156_a(task.field_75733_a);
        }
    }

    private void addHorseAI() {
        if (this.horse.field_70714_bg.field_75782_a.isEmpty()) {
            this.horse.field_70714_bg.field_75782_a.addAll(this.horseAI);
        }
        this.horseAI.clear();
    }
}

