/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import net.minecraft.util.math.BlockPos;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIMoveHome
extends NpcAI<NpcBase> {
    private static final int TICKER_MAX = 10;
    private final float dayRange;
    private final float nightRange;
    private final float dayLeash;
    private final float nightLeash;
    private int ticker = 0;
    private boolean goneHome = false;

    public NpcAIMoveHome(NpcBase npc, float dayRange, float nightRange, float dayLeash, float nightLeash) {
        super(npc);
        this.func_75248_a(3);
        this.dayRange = dayRange;
        this.nightRange = nightRange;
        this.dayLeash = dayLeash;
        this.nightLeash = nightLeash;
    }

    @Override
    public boolean func_75250_a() {
        if (!super.func_75250_a() || !this.npc.func_110175_bO()) {
            return false;
        }
        BlockPos cc = this.npc.func_180486_cf();
        float distSq = (float)this.npc.func_70092_e((double)cc.func_177958_n() + 0.5, cc.func_177956_o(), (double)cc.func_177952_p() + 0.5);
        return this.npc.shouldBeAtHome() || this.exceedsRange(distSq);
    }

    protected boolean exceedsRange(float distSq) {
        float range = this.getRange() * this.getRange();
        return distSq > range;
    }

    protected float getLeashRange() {
        return !this.npc.shouldSleep() ? this.dayLeash : this.nightLeash;
    }

    protected float getRange() {
        return !this.npc.shouldSleep() ? this.dayRange : this.nightRange;
    }

    public void func_75249_e() {
        this.npc.addAITask(8);
        this.updateTasks();
        this.goneHome = false;
    }

    public void func_75246_d() {
        double leash;
        ++this.ticker;
        if (this.ticker >= 10 && this.npc.isSleeping()) {
            if (this.npc.isBedCacheValid()) {
                this.npc.setPositionToBed();
            } else {
                this.npc.wakeUp();
            }
            return;
        }
        BlockPos cc = this.npc.func_180486_cf();
        double dist = this.npc.func_70092_e((double)cc.func_177958_n() + 0.5, cc.func_177956_o(), (double)cc.func_177952_p() + 0.5);
        if (dist > (leash = (double)(this.getLeashRange() * this.getLeashRange())) && !this.goneHome && !this.npc.isSleeping()) {
            this.npc.addAITask(512);
            this.moveToPosition(cc, dist);
        } else {
            this.stopMovingOrSleepAtHome();
        }
        if (this.ticker >= 10) {
            this.updateTasks();
            this.ticker = 0;
        }
    }

    private void stopMovingOrSleepAtHome() {
        this.npc.removeAITask(512);
        this.goneHome = true;
        if (this.npc.getOwner().getName().isEmpty()) {
            this.stopMovement();
        } else if (this.ticker >= 10 && this.npc.shouldSleep()) {
            this.layInBed();
        }
    }

    private void layInBed() {
        BlockPos pos = this.npc.findBed();
        if (pos != null) {
            double dist = this.npc.func_174818_b(pos);
            if (dist > (double)(AWNPCStatics.npcActionRange * AWNPCStatics.npcActionRange)) {
                this.forceMoveToPosition(pos, dist);
            } else if (this.npc.lieDown(pos)) {
                this.npc.setPositionToBed();
                this.stopMovement();
            }
        }
    }

    private void updateTasks() {
        if (this.npc.shouldSleep()) {
            this.npc.addAITask(4096);
        } else {
            this.npc.removeAITask(4096);
        }
        if (!this.npc.worksInRain() && this.npc.field_70170_p.func_72896_J()) {
            this.npc.addAITask(8192);
        } else {
            this.npc.removeAITask(8192);
        }
    }

    private void stopMovement() {
        this.npc.removeAITask(512);
        this.npc.func_70661_as().func_75499_g();
    }

    public void func_75251_c() {
        this.stopMovement();
        this.npc.removeAITask(12296);
        if (this.npc.isSleeping()) {
            this.npc.wakeUp();
        }
    }
}

