/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc.ai;

import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.shadowmage.ancientwarfare.npc.ai.NpcAI;
import net.shadowmage.ancientwarfare.npc.entity.NpcBase;

public class NpcAIBlockWithShield
extends NpcAI<NpcBase> {
    private EntityLivingBase target;
    private static final float SAFE_MELEE_DISTANCE = 4.5f;
    private final int maxReactionDelay = 5;
    private final int maxReactionDelayBow = 30;
    private int reactionDelayTicks = 0;
    private static final int SHIELD_WITHDRAW_DELAY = 40;
    private int shieldWithdrawTicks = 0;

    public NpcAIBlockWithShield(NpcBase npc) {
        super(npc);
    }

    @Override
    public boolean func_75250_a() {
        return super.func_75250_a() && this.canExecute(e -> e.func_70089_S() && this.shouldDefendFrom((EntityLivingBase)e));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canExecute(Predicate<EntityLivingBase> defendFrom) {
        if (this.target == null) {
            if (!this.hasShieldInOffhand()) return false;
            if (this.npc.getShieldDisabledTick() > 0) return false;
            if (this.shieldWithdrawTicks > 0) return true;
            if (this.getAttackTarget().map(defendFrom::test).orElse(false) == false) return false;
            return true;
        }
        if (!this.hasShieldInOffhand()) return false;
        if (this.npc.getShieldDisabledTick() > 0) return false;
        if (!this.target.func_70089_S()) return false;
        if (!this.getAttackTarget().isPresent()) return false;
        if (this.shieldWithdrawTicks > 0) return true;
        if (this.getAttackTarget().map(t -> t.equals((Object)this.target) && this.shouldDefendFrom(this.target)).orElse(false) == false) return false;
        return true;
    }

    private boolean shouldDefendFrom(@Nullable EntityLivingBase e) {
        return e != null && this.isPlayerOrTargetsThisNpc(e) && (e.field_82175_bq && this.npc.func_70032_d((Entity)e) < 4.0f || this.isAimingWithBow(e));
    }

    private boolean isPlayerOrTargetsThisNpc(EntityLivingBase e) {
        if (e instanceof EntityPlayer) {
            return true;
        }
        if (e instanceof EntityLiving) {
            EntityLiving living = (EntityLiving)e;
            return living.func_70638_az() != null && living.func_70638_az().equals((Object)this.npc);
        }
        return false;
    }

    public void func_75249_e() {
        if (!this.npc.func_184587_cr()) {
            this.init();
        }
    }

    private void init() {
        this.target = this.getAttackTarget().orElse(null);
        this.reactionDelayTicks = new Random(this.npc.field_70170_p.func_82737_E()).nextInt(this.target != null && this.isAimingWithBow(this.target) ? 30 : 5);
        this.shieldWithdrawTicks = 40;
    }

    public final void func_75251_c() {
        this.target = null;
        this.reactionDelayTicks = 0;
        this.npc.startAIControlFlag(2);
    }

    public final void func_75246_d() {
        if (this.reactionDelayTicks > 0) {
            --this.reactionDelayTicks;
            return;
        }
        if (!this.shouldDefendFrom(this.target)) {
            --this.shieldWithdrawTicks;
            return;
        }
        this.npc.stopAIControlFlag(2);
        this.npc.func_184598_c(EnumHand.OFF_HAND);
        this.npc.field_184628_bn = 40;
        this.npc.func_70661_as().func_75499_g();
        if (this.target != null) {
            this.npc.func_70671_ap().func_75651_a((Entity)this.target, 30.0f, 30.0f);
            double distanceToEntity = this.npc.func_70092_e(this.target.field_70165_t, this.target.func_174813_aQ().field_72338_b, this.target.field_70161_v);
            if (!this.shouldCloseOnTarget(distanceToEntity) || this.isAimingWithBow(this.target)) {
                this.startBlocking();
                this.npc.func_70661_as().func_75492_a(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v, (double)(this.npc.getDefaultMoveSpeed() * 0.5f));
            }
        }
    }

    private void startBlocking() {
        this.npc.func_184598_c(EnumHand.OFF_HAND);
    }

    private Optional<EntityLivingBase> getAttackTarget() {
        return this.npc.func_70638_az() != null ? Optional.of(this.npc.func_70638_az()) : Optional.ofNullable(this.npc.func_70643_av());
    }

    protected boolean shouldCloseOnTarget(double distanceToEntity) {
        double attackDistance = (double)this.npc.field_70130_N / 2.0 + (double)this.getTarget().field_70130_N / 2.0 + 4.5;
        return distanceToEntity > attackDistance * attackDistance || !this.npc.func_70635_at().func_75522_a((Entity)this.getTarget());
    }

    public final EntityLivingBase getTarget() {
        return this.target;
    }

    private boolean hasShieldInOffhand() {
        return this.npc.func_184592_cb().func_77973_b().isShield(this.npc.func_184592_cb(), (EntityLivingBase)this.npc);
    }

    private boolean isAimingWithBow(EntityLivingBase entity) {
        return this.npc.isBow(entity.func_184614_ca().func_77973_b()) && entity.func_184587_cr() && entity.func_184600_cs() == EnumHand.MAIN_HAND || this.npc.isBow(entity.func_184592_cb().func_77973_b()) && entity.func_184587_cr() && entity.func_184600_cs() == EnumHand.OFF_HAND;
    }

    public void onPreDamage(DamageSource source, float damage) {
        if (damage > 0.0f && !source.func_76363_c() && this.canExecute(EntityLivingBase::func_70089_S)) {
            this.init();
            this.func_75246_d();
        }
    }
}

