/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.npc;

import java.util.function.Supplier;
import net.minecraft.command.ICommand;
import net.minecraft.world.storage.loot.properties.EntityProperty;
import net.minecraft.world.storage.loot.properties.EntityPropertyManager;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.event.FMLServerStartingEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.shadowmage.ancientwarfare.core.compat.CompatLoader;
import net.shadowmage.ancientwarfare.core.gamedata.AWGameData;
import net.shadowmage.ancientwarfare.core.gamedata.WorldData;
import net.shadowmage.ancientwarfare.core.network.NetworkHandler;
import net.shadowmage.ancientwarfare.core.network.PacketBase;
import net.shadowmage.ancientwarfare.core.registry.RegistryLoader;
import net.shadowmage.ancientwarfare.npc.AWNPCTab;
import net.shadowmage.ancientwarfare.npc.command.CommandDebugAI;
import net.shadowmage.ancientwarfare.npc.command.CommandFaction;
import net.shadowmage.ancientwarfare.npc.command.CommandTeams;
import net.shadowmage.ancientwarfare.npc.compat.EpicSiegeCompat;
import net.shadowmage.ancientwarfare.npc.compat.TwilightForestCompat;
import net.shadowmage.ancientwarfare.npc.compat.ebwizardry.EBWizardryCompat;
import net.shadowmage.ancientwarfare.npc.config.AWNPCStatics;
import net.shadowmage.ancientwarfare.npc.container.ContainerCombatOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcBard;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcCreativeControls;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionBard;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionSpellcasterWizardry;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionTradeSetup;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcFactionTradeView;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcInventory;
import net.shadowmage.ancientwarfare.npc.container.ContainerNpcPlayerOwnedTrade;
import net.shadowmage.ancientwarfare.npc.container.ContainerRoutingOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerTownHall;
import net.shadowmage.ancientwarfare.npc.container.ContainerTradeOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerUpkeepOrder;
import net.shadowmage.ancientwarfare.npc.container.ContainerWorkOrder;
import net.shadowmage.ancientwarfare.npc.entity.faction.attributes.EntityVehicleProperty;
import net.shadowmage.ancientwarfare.npc.event.EventHandler;
import net.shadowmage.ancientwarfare.npc.faction.FactionTracker;
import net.shadowmage.ancientwarfare.npc.init.AWNPCEntities;
import net.shadowmage.ancientwarfare.npc.init.AWNPCItems;
import net.shadowmage.ancientwarfare.npc.network.PacketExtendedReachAttack;
import net.shadowmage.ancientwarfare.npc.network.PacketFactionUpdate;
import net.shadowmage.ancientwarfare.npc.network.PacketNpcCommand;
import net.shadowmage.ancientwarfare.npc.network.PacketTeamMembershipUpdate;
import net.shadowmage.ancientwarfare.npc.network.PacketTeamStandingUpdate;
import net.shadowmage.ancientwarfare.npc.network.PacketTeamStandingsUpdate;
import net.shadowmage.ancientwarfare.npc.proxy.NpcCommonProxy;
import net.shadowmage.ancientwarfare.npc.registry.FactionRegistry;
import net.shadowmage.ancientwarfare.npc.registry.FactionTradeListRegistry;
import net.shadowmage.ancientwarfare.npc.registry.NpcDefaultsRegistry;
import net.shadowmage.ancientwarfare.npc.registry.TargetRegistry;
import net.shadowmage.ancientwarfare.structure.network.PacketStructureEntry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(name="Ancient Warfare NPCs", modid="ancientwarfarenpc", version="1.12.2-2.7.0.1038", dependencies="required-after:ancientwarfare", acceptedMinecraftVersions="[1.12.2]")
public class AncientWarfareNPC {
    public static final String MOD_ID = "ancientwarfarenpc";
    public static final String MOD_PREFIX = "ancientwarfarenpc:";
    public static final AWNPCTab TAB = new AWNPCTab();
    @Mod.Instance(value="ancientwarfarenpc")
    public static AncientWarfareNPC instance;
    @SidedProxy(clientSide="net.shadowmage.ancientwarfare.npc.proxy.NpcClientProxy", serverSide="net.shadowmage.ancientwarfare.npc.proxy.NpcCommonProxy")
    public static NpcCommonProxy proxy;
    public static final Logger LOG;
    public static AWNPCStatics statics;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent evt) {
        statics = new AWNPCStatics("AncientWarfareNpc");
        EntityPropertyManager.func_186644_a((EntityProperty.Serializer)new EntityVehicleProperty.Serializer());
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)EventHandler.INSTANCE);
        NetworkHandler.registerContainer(4, ContainerNpcInventory.class);
        NetworkHandler.registerContainer(34, ContainerWorkOrder.class);
        NetworkHandler.registerContainer(35, ContainerUpkeepOrder.class);
        NetworkHandler.registerContainer(36, ContainerCombatOrder.class);
        NetworkHandler.registerContainer(39, ContainerNpcFactionTradeSetup.class);
        NetworkHandler.registerContainer(42, ContainerNpcFactionTradeView.class);
        NetworkHandler.registerContainer(37, ContainerRoutingOrder.class);
        NetworkHandler.registerContainer(41, ContainerTownHall.class);
        NetworkHandler.registerContainer(43, ContainerNpcBard.class);
        NetworkHandler.registerContainer(44, ContainerNpcCreativeControls.class);
        NetworkHandler.registerContainer(6, ContainerTradeOrder.class);
        NetworkHandler.registerContainer(47, ContainerNpcPlayerOwnedTrade.class);
        NetworkHandler.registerContainer(49, ContainerNpcFactionBard.class);
        Supplier<Runnable> registerWizardrySpellcaster = () -> () -> NetworkHandler.registerContainer(62, ContainerNpcFactionSpellcasterWizardry.class);
        if (Loader.isModLoaded((String)"ebwizardry")) {
            registerWizardrySpellcaster.get().run();
        }
        PacketBase.registerPacketType(12, PacketNpcCommand.class, PacketNpcCommand::new);
        PacketBase.registerPacketType(13, PacketFactionUpdate.class, PacketFactionUpdate::new);
        PacketBase.registerPacketType(27, PacketExtendedReachAttack.class, PacketExtendedReachAttack::new);
        PacketBase.registerPacketType(29, PacketStructureEntry.class, PacketStructureEntry::new);
        PacketBase.registerPacketType(31, PacketTeamMembershipUpdate.class, PacketTeamMembershipUpdate::new);
        PacketBase.registerPacketType(32, PacketTeamStandingsUpdate.class, PacketTeamStandingsUpdate::new);
        PacketBase.registerPacketType(33, PacketTeamStandingUpdate.class, PacketTeamStandingUpdate::new);
        CompatLoader.registerCompat(new EpicSiegeCompat());
        CompatLoader.registerCompat(new TwilightForestCompat());
        CompatLoader.registerCompat(new EBWizardryCompat());
        RegistryLoader.registerParser(new FactionRegistry.FactionParser());
        RegistryLoader.registerParser(new TargetRegistry.TargetListParser());
        RegistryLoader.registerParser(new NpcDefaultsRegistry.FactionNpcDefaultsParser());
        RegistryLoader.registerParser(new NpcDefaultsRegistry.OwnedNpcDefaultsParser());
        RegistryLoader.registerParser(new FactionTradeListRegistry.Parser());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        proxy.init();
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent evt) {
        proxy.loadSkins();
        AWNPCEntities.loadNpcSubtypeEquipment();
        MinecraftForge.EVENT_BUS.register((Object)FactionTracker.INSTANCE);
        statics.save();
        AWNPCItems.addFactionBlocks();
    }

    @SubscribeEvent
    public void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent evt) {
        if ("ancientwarfare".equals(evt.getModID())) {
            statics.save();
        }
    }

    @Mod.EventHandler
    public void serverStart(FMLServerStartingEvent evt) {
        evt.registerServerCommand((ICommand)new CommandFaction());
        evt.registerServerCommand((ICommand)new CommandTeams());
        evt.registerServerCommand((ICommand)new CommandDebugAI());
    }

    @SubscribeEvent
    public void worldLoaded(WorldEvent.Load evt) {
        WorldData d;
        if (!evt.getWorld().field_72995_K && (d = AWGameData.INSTANCE.getPerWorldData(evt.getWorld(), WorldData.class)) != null) {
            AWNPCStatics.npcAIDebugMode = d.get("NpcAIDebugMode");
        }
    }

    static {
        LOG = LogManager.getLogger((String)MOD_ID);
    }
}

