/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.item.ItemRecord;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;

public class SongPlayData {
    private boolean random = false;
    private boolean playOnPlayerEntry = false;
    private int minDelay;
    private int maxDelay;
    private List<SongEntry> tunes = new ArrayList<SongEntry>();

    public int size() {
        return this.tunes.size();
    }

    public SongEntry get(int index) {
        return this.tunes.get(index);
    }

    public void addNewEntry() {
        SongEntry e = new SongEntry();
        this.tunes.add(e);
    }

    public void decrementEntry(int index) {
        if (index <= 0 || index >= this.tunes.size()) {
            return;
        }
        SongEntry e = this.tunes.remove(index);
        this.tunes.add(--index, e);
    }

    public void incrementEntry(int index) {
        if (index < 0 || index >= this.tunes.size() - 1) {
            return;
        }
        SongEntry e = this.tunes.remove(index);
        this.tunes.add(++index, e);
    }

    public void deleteEntry(int index) {
        if (index < 0 || index >= this.tunes.size()) {
            return;
        }
        this.tunes.remove(index);
    }

    public int getMinDelay() {
        return this.minDelay;
    }

    public int getMaxDelay() {
        return this.maxDelay;
    }

    public boolean getPlayOnPlayerEntry() {
        return this.playOnPlayerEntry;
    }

    public boolean getIsRandom() {
        return this.random;
    }

    public void setMinDelay(int val) {
        this.minDelay = val;
    }

    public void setMaxDelay(int val) {
        this.maxDelay = val;
    }

    public void setPlayOnPlayerEntry(boolean val) {
        this.playOnPlayerEntry = val;
    }

    public void setRandom(boolean val) {
        this.random = val;
    }

    public void readFromNBT(NBTTagCompound tag) {
        this.minDelay = tag.func_74762_e("minDelay");
        this.maxDelay = tag.func_74762_e("maxDelay");
        if (this.maxDelay < this.minDelay) {
            this.maxDelay = this.minDelay;
        }
        this.random = tag.func_74767_n("random");
        this.playOnPlayerEntry = tag.func_74767_n("playerEntry");
        this.tunes.clear();
        NBTTagList l = tag.func_150295_c("entries", 10);
        for (int i = 0; i < l.func_74745_c(); ++i) {
            SongEntry d = new SongEntry();
            d.readFromNBT(l.func_150305_b(i));
            this.tunes.add(d);
        }
    }

    public NBTTagCompound writeToNBT(NBTTagCompound tag) {
        tag.func_74768_a("minDelay", this.minDelay);
        tag.func_74768_a("maxDelay", this.maxDelay);
        tag.func_74757_a("random", this.random);
        tag.func_74757_a("playerEntry", this.playOnPlayerEntry);
        NBTTagList l = new NBTTagList();
        for (SongEntry tune : this.tunes) {
            l.func_74742_a((NBTBase)tune.writeToNBT(new NBTTagCompound()));
        }
        tag.func_74782_a("entries", (NBTBase)l);
        return tag;
    }

    public static final class SongEntry {
        private static final String AUTO_LOAD_PREFIX = "auto_load/";
        private ResourceLocation soundRegistryName = null;
        @Nullable
        private SoundEvent sound = null;
        private float length = 5.0f;
        private int volume = 100;

        private SongEntry() {
        }

        public void setLength(float length) {
            this.length = length;
        }

        @SideOnly(value=Side.CLIENT)
        public void setSound(@Nullable SoundEvent sound) {
            this.sound = sound;
            ResourceLocation resourceLocation = this.soundRegistryName = sound == null ? null : sound.getRegistryName();
            if (sound != null) {
                boolean isRecord;
                boolean bl = isRecord = sound.func_187503_a().func_110623_a().startsWith("records.") || ItemRecord.func_185074_a((SoundEvent)sound) != null;
                if (isRecord && this.length() < 120.0f) {
                    this.setLength(120.0f);
                }
            }
        }

        public void setVolume(int volume) {
            this.volume = volume;
        }

        public int volume() {
            return this.volume;
        }

        @SideOnly(value=Side.CLIENT)
        public String name() {
            return this.sound != null ? this.sound.func_187503_a().toString() : "";
        }

        public Optional<SoundEvent> getSound() {
            return Optional.ofNullable(this.sound);
        }

        public float length() {
            return this.length;
        }

        public void readFromNBT(NBTTagCompound tag) {
            if (tag.func_74764_b("name")) {
                this.soundRegistryName = new ResourceLocation(tag.func_74779_i("name"));
                this.sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(this.soundRegistryName);
            }
            this.length = tag.func_74760_g("length");
            this.volume = tag.func_74762_e("volume");
        }

        private void trySoundLookup() {
            if (!this.soundRegistryName.func_110624_b().startsWith("ancientwarfare") || !this.soundRegistryName.func_110623_a().startsWith(AUTO_LOAD_PREFIX)) {
                return;
            }
            String soundDomain = this.soundRegistryName.func_110624_b();
            String soundName = this.soundRegistryName.func_110623_a().substring(AUTO_LOAD_PREFIX.length());
            SoundEvent found = null;
            for (SoundEvent soundEvent : ForgeRegistries.SOUND_EVENTS) {
                ResourceLocation soundEventRegistryName = soundEvent.getRegistryName();
                String resPath = soundEventRegistryName.func_110623_a();
                if (!soundEventRegistryName.func_110624_b().equals(soundDomain) || !resPath.equals(soundName) && !resPath.endsWith("/" + soundName)) continue;
                found = soundEvent;
                if (resPath.startsWith(AUTO_LOAD_PREFIX)) continue;
                break;
            }
            if (found != null) {
                AncientWarfareCore.LOG.info("Sound {} replaced with automatically found {}", (Object)this.soundRegistryName, (Object)found.getRegistryName());
                this.sound = found;
                this.soundRegistryName = found.getRegistryName();
            } else {
                AncientWarfareCore.LOG.error("Sound {} no longer exists in the sound registry and no replacement was automatically found.\nThe sound name will be saved in case the sound is reregistered.", (Object)this.soundRegistryName);
            }
        }

        public NBTTagCompound writeToNBT(NBTTagCompound tag) {
            if (this.soundRegistryName != null) {
                tag.func_74778_a("name", this.soundRegistryName.toString());
            }
            tag.func_74776_a("length", this.length);
            tag.func_74768_a("volume", this.volume);
            return tag;
        }
    }
}

