/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.awt.Color;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class RenderTools {
    private RenderTools() {
    }

    public static void setFullColorLightmap() {
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)0.0f, (float)240.0f);
    }

    public static void renderQuarteredTexture(int textureWidth, int textureHeight, int texStartX, int texStartY, int texUsedWidth, int texUsedHeight, int renderStartX, int renderStartY, int renderWidth, int renderHeight) {
        float perX = 1.0f / (float)textureWidth;
        float perY = 1.0f / (float)textureHeight;
        float texMinX = (float)texStartX * perX;
        float texMinY = (float)texStartY * perY;
        float texMaxX = (float)(texStartX + texUsedWidth) * perX;
        float texMaxY = (float)(texStartY + texUsedHeight) * perY;
        float halfWidth = (float)renderWidth / 2.0f * perX;
        float halfHeight = (float)renderHeight / 2.0f * perY;
        float halfRenderWidth = (float)renderWidth * 0.5f;
        float halfRenderHeight = (float)renderHeight * 0.5f;
        RenderTools.renderTexturedQuad(renderStartX, renderStartY, (float)renderStartX + halfRenderWidth, (float)renderStartY + halfRenderHeight, texMinX, texMinY, texMinX + halfWidth, texMinY + halfHeight);
        RenderTools.renderTexturedQuad((float)renderStartX + halfRenderWidth, renderStartY, (float)renderStartX + halfRenderWidth * 2.0f, (float)renderStartY + halfRenderHeight, texMaxX - halfWidth, texMinY, texMaxX, texMinY + halfHeight);
        RenderTools.renderTexturedQuad(renderStartX, (float)renderStartY + halfRenderHeight, (float)renderStartX + halfRenderWidth, (float)renderStartY + halfRenderHeight * 2.0f, texMinX, texMaxY - halfHeight, texMinX + halfWidth, texMaxY);
        RenderTools.renderTexturedQuad((float)renderStartX + halfRenderWidth, (float)renderStartY + halfRenderHeight, (float)renderStartX + halfRenderWidth * 2.0f, (float)renderStartY + halfRenderHeight * 2.0f, texMaxX - halfWidth, texMaxY - halfHeight, texMaxX, texMaxY);
    }

    public static void renderTexturedQuad(float x1, float y1, float x2, float y2, float u1, float v1, float u2, float v2) {
        GlStateManager.func_187447_r((int)7);
        GlStateManager.func_187426_b((float)u1, (float)v1);
        GL11.glVertex2f((float)x1, (float)y1);
        GlStateManager.func_187426_b((float)u1, (float)v2);
        GL11.glVertex2f((float)x1, (float)y2);
        GlStateManager.func_187426_b((float)u2, (float)v2);
        GL11.glVertex2f((float)x2, (float)y2);
        GlStateManager.func_187426_b((float)u2, (float)v1);
        GL11.glVertex2f((float)x2, (float)y1);
        GlStateManager.func_187437_J();
    }

    public static void renderColoredQuad(int renderStartX, int renderStartY, int renderWidth, int renderHeight, float colorRed, float colorGreen, float colorBlue) {
        GlStateManager.func_187447_r((int)7);
        GlStateManager.func_179124_c((float)colorRed, (float)colorGreen, (float)colorBlue);
        GL11.glVertex2f((float)renderStartX, (float)renderStartY);
        GL11.glVertex2f((float)renderStartX, (float)((float)renderStartY + (float)renderHeight));
        GL11.glVertex2f((float)((float)renderStartX + (float)renderWidth), (float)((float)renderStartY + (float)renderHeight));
        GL11.glVertex2f((float)((float)renderStartX + (float)renderWidth), (float)renderStartY);
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187437_J();
    }

    public static void drawOutlinedBoundingBox2(AxisAlignedBB bb, float r, float g, float b, float width) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.4f);
        GlStateManager.func_179144_i((int)0);
        float hw = width / 2.0f;
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72338_b - hw, (float)bb.field_72339_c - hw, (float)bb.field_72336_d, (float)bb.field_72338_b + hw, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72337_e - hw, (float)bb.field_72339_c - hw, (float)bb.field_72336_d, (float)bb.field_72337_e + hw, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72338_b - hw, (float)bb.field_72334_f - hw, (float)bb.field_72336_d, (float)bb.field_72338_b + hw, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a, (float)bb.field_72337_e - hw, (float)bb.field_72334_f - hw, (float)bb.field_72336_d, (float)bb.field_72337_e + hw, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72338_b, (float)bb.field_72339_c - hw, (float)bb.field_72340_a + hw, (float)bb.field_72337_e, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72338_b, (float)bb.field_72339_c - hw, (float)bb.field_72336_d + hw, (float)bb.field_72337_e, (float)bb.field_72339_c + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72338_b, (float)bb.field_72334_f - hw, (float)bb.field_72340_a + hw, (float)bb.field_72337_e, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72338_b, (float)bb.field_72334_f - hw, (float)bb.field_72336_d + hw, (float)bb.field_72337_e, (float)bb.field_72334_f + hw);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72338_b - hw, (float)bb.field_72339_c, (float)bb.field_72340_a + hw, (float)bb.field_72338_b + hw, (float)bb.field_72334_f);
        RenderTools.drawCuboid((float)bb.field_72340_a - hw, (float)bb.field_72337_e - hw, (float)bb.field_72339_c, (float)bb.field_72340_a + hw, (float)bb.field_72337_e + hw, (float)bb.field_72334_f);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72338_b - hw, (float)bb.field_72339_c, (float)bb.field_72336_d + hw, (float)bb.field_72338_b + hw, (float)bb.field_72334_f);
        RenderTools.drawCuboid((float)bb.field_72336_d - hw, (float)bb.field_72337_e - hw, (float)bb.field_72339_c, (float)bb.field_72336_d + hw, (float)bb.field_72337_e + hw, (float)bb.field_72334_f);
        GlStateManager.func_179084_k();
    }

    private static void drawCuboid(float x, float y, float z, float mx, float my, float mz) {
        GlStateManager.func_187447_r((int)7);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187435_e((float)x, (float)my, (float)mz);
        GlStateManager.func_187435_e((float)x, (float)y, (float)mz);
        GlStateManager.func_187435_e((float)mx, (float)y, (float)mz);
        GlStateManager.func_187435_e((float)mx, (float)my, (float)mz);
        GlStateManager.func_187432_a((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)mx, (float)my, (float)mz);
        GlStateManager.func_187435_e((float)mx, (float)y, (float)mz);
        GlStateManager.func_187435_e((float)mx, (float)y, (float)z);
        GlStateManager.func_187435_e((float)mx, (float)my, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)x, (float)my, (float)z);
        GlStateManager.func_187435_e((float)x, (float)my, (float)mz);
        GlStateManager.func_187435_e((float)mx, (float)my, (float)mz);
        GlStateManager.func_187435_e((float)mx, (float)my, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)0.0f, (float)-1.0f);
        GlStateManager.func_187435_e((float)x, (float)my, (float)z);
        GlStateManager.func_187435_e((float)mx, (float)my, (float)z);
        GlStateManager.func_187435_e((float)mx, (float)y, (float)z);
        GlStateManager.func_187435_e((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)-1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)x, (float)y, (float)mz);
        GlStateManager.func_187435_e((float)x, (float)my, (float)mz);
        GlStateManager.func_187435_e((float)x, (float)my, (float)z);
        GlStateManager.func_187435_e((float)x, (float)y, (float)z);
        GlStateManager.func_187432_a((float)0.0f, (float)-1.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)x, (float)y, (float)z);
        GlStateManager.func_187435_e((float)mx, (float)y, (float)z);
        GlStateManager.func_187435_e((float)mx, (float)y, (float)mz);
        GlStateManager.func_187435_e((float)x, (float)y, (float)mz);
        GlStateManager.func_187437_J();
    }

    public static void renderOrientationPoints(float colorMult) {
        GlStateManager.func_179094_E();
        GL11.glPushAttrib((int)8192);
        GlStateManager.func_179090_x();
        GlStateManager.func_179140_f();
        GL11.glPointSize((float)3.0f);
        GlStateManager.func_179131_c((float)colorMult, (float)colorMult, (float)colorMult, (float)1.0f);
        GlStateManager.func_187447_r((int)0);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)colorMult, (float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187447_r((int)1);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_187447_r((int)0);
        GlStateManager.func_187435_e((float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)0.0f, (float)colorMult, (float)0.0f, (float)1.0f);
        GlStateManager.func_187447_r((int)1);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_187447_r((int)0);
        GlStateManager.func_187435_e((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)0.0f, (float)0.0f, (float)colorMult, (float)1.0f);
        GlStateManager.func_187447_r((int)1);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)0.0f);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_187447_r((int)0);
        GlStateManager.func_187435_e((float)0.0f, (float)0.0f, (float)1.0f);
        GlStateManager.func_187437_J();
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179099_b();
        GlStateManager.func_179121_F();
    }

    public static void drawTopSideOverlay(AxisAlignedBB bb, Color color) {
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179094_E();
        GlStateManager.func_179131_c((float)color.getRed(), (float)color.getGreen(), (float)color.getBlue(), (float)((float)color.getAlpha() / 255.0f));
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        float yOffset = 0.01f;
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e + (double)yOffset, bb.field_72334_f).func_187315_a(0.0, 0.0).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72337_e + (double)yOffset, bb.field_72334_f).func_187315_a(0.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72337_e + (double)yOffset, bb.field_72339_c).func_187315_a(1.0, 1.0).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e + (double)yOffset, bb.field_72339_c).func_187315_a(1.0, 0.0).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179121_F();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB bb, Color color) {
        RenderTools.drawOutlinedBoundingBox(bb, color, false);
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB bb, Color color, boolean disableDepth) {
        RenderTools.drawOutlinedBoundingBox(bb, color.getRed(), color.getGreen(), color.getBlue(), disableDepth);
    }

    public static void drawOutlinedBoundingBox(AxisAlignedBB bb, float r, float g, float b) {
        RenderTools.drawOutlinedBoundingBox(bb, r, g, b, false);
    }

    private static void drawOutlinedBoundingBox(AxisAlignedBB bb, float r, float g, float b, boolean disabledDepth) {
        GlStateManager.func_179147_l();
        GlStateManager.func_179112_b((int)770, (int)771);
        GlStateManager.func_179131_c((float)r, (float)g, (float)b, (float)0.4f);
        GlStateManager.func_187441_d((float)8.0f);
        GlStateManager.func_179090_x();
        if (disabledDepth) {
            GlStateManager.func_179097_i();
        }
        GlStateManager.func_179132_a((boolean)false);
        Tessellator tess = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tess.func_178180_c();
        RenderTools.drawBottomOutline(bb, bufferBuilder);
        tess.func_78381_a();
        RenderTools.drawTopOutline(bb, bufferBuilder);
        tess.func_78381_a();
        bufferBuilder.func_181668_a(1, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        tess.func_78381_a();
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    private static void drawTopOutline(AxisAlignedBB bb, BufferBuilder bufferBuilder) {
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72337_e, bb.field_72339_c).func_181675_d();
    }

    private static void drawBottomOutline(AxisAlignedBB bb, BufferBuilder bufferBuilder) {
        bufferBuilder.func_181668_a(3, DefaultVertexFormats.field_181705_e);
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72339_c).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72336_d, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72334_f).func_181675_d();
        bufferBuilder.func_181662_b(bb.field_72340_a, bb.field_72338_b, bb.field_72339_c).func_181675_d();
    }

    public static AxisAlignedBB adjustBBForPlayerPos(AxisAlignedBB bb, EntityPlayer player, float partialTick) {
        double x = RenderTools.getRenderOffsetX(player, partialTick);
        double y = RenderTools.getRenderOffsetY(player, partialTick);
        double z = RenderTools.getRenderOffsetZ(player, partialTick);
        return bb.func_72317_d(-x, -y, -z);
    }

    public static double getRenderOffsetX(EntityPlayer player, float partialTick) {
        return player.field_70142_S + (player.field_70165_t - player.field_70142_S) * (double)partialTick;
    }

    public static double getRenderOffsetY(EntityPlayer player, float partialTick) {
        return player.field_70137_T + (player.field_70163_u - player.field_70137_T) * (double)partialTick;
    }

    public static double getRenderOffsetZ(EntityPlayer player, float partialTick) {
        return player.field_70136_U + (player.field_70161_v - player.field_70136_U) * (double)partialTick;
    }

    @SideOnly(value=Side.CLIENT)
    public static void renderTESR(@Nullable TileEntity te, BlockPos pos) {
        TileEntitySpecialRenderer renderer = TileEntityRendererDispatcher.field_147556_a.func_147547_b(te);
        if (renderer != null) {
            World dispatcherWorld = TileEntityRendererDispatcher.field_147556_a.field_147550_f;
            TileEntityRendererDispatcher.field_147556_a.func_147543_a(te.func_145831_w());
            renderer.func_192841_a(te, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 0.0f, -1, 1.0f);
            TileEntityRendererDispatcher.field_147556_a.func_147543_a(dispatcherWorld);
        }
    }
}

