/*
 * Decompiled with CFR 0.152.
 */
package net.shadowmage.ancientwarfare.core.util;

import java.util.MissingResourceException;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.shadowmage.ancientwarfare.core.AncientWarfareCore;
import org.apache.logging.log4j.util.Supplier;

public class RegistryTools {
    public static final ResourceLocation EMPTY_REGISTRY_NAME = new ResourceLocation("", "");

    private RegistryTools() {
    }

    static Block getBlock(String registryName) {
        return RegistryTools.getRegistryEntry(registryName, ForgeRegistries.BLOCKS, Blocks.field_150350_a);
    }

    public static Item getItem(String registryName) {
        return RegistryTools.getRegistryEntry(registryName, ForgeRegistries.ITEMS, Items.field_190931_a);
    }

    private static <T extends IForgeRegistryEntry<T>> T getRegistryEntry(String registryName, IForgeRegistry<T> registry, T defaultValue) {
        ResourceLocation key = new ResourceLocation(registryName);
        if (!registry.containsKey(key)) {
            if (!Loader.isModLoaded((String)key.func_110624_b())) {
                Supplier[] supplierArray = new Supplier[3];
                supplierArray[0] = () -> ((ResourceLocation)key).func_110624_b();
                supplierArray[1] = () -> ((ResourceLocation)key).toString();
                supplierArray[2] = () -> defaultValue.getRegistryName().toString();
                AncientWarfareCore.LOG.debug("Mod {} is not loaded. Replacing {} with {}", supplierArray);
                return defaultValue;
            }
            throw new MissingResourceException("Unable to find entry with registry name \"" + registryName + "\"", registry.getRegistrySuperType().getName(), registryName);
        }
        return (T)registry.getValue(key);
    }
}

